/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IceBlockPheasantProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE).build();

    public IceBlockPheasantProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBlockPheasantProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)HieProjectiles.ICE_BLOCK_PHEASANT.get(), world, player, ability);
        this.setDamage(45.0f);
        this.setArmorPiercing(1.0f);
        this.setPassThroughEntities();
        this.setMaxLife(60);
        super.setPhysical();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        AbilityHelper.addFrostbiteStacks(entity, super.getThrower(), 6);
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_233580_cy_().func_177979_c(j);
                break;
            }
            if (j > 2) break;
            ++j;
        }
        if (pos != null) {
            int size = 2 + 4 * (this.getMaxLife() - this.getLife()) / this.getMaxLife();
            AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size, Blocks.field_205164_gk, GRIEF_RULE);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = WyHelper.randomDouble();
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble();
                SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.HIE.get());
                part.setLife(14);
                part.setAnimationSpeed(2);
                part.setRotation(Vector3f.field_229183_f_);
                part.setRotationSpeed(i % 2 == 0 ? 0.07f : -0.07f);
                part.setSize(1.5f);
                WyHelper.spawnParticles(part, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

