/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ito.ItoProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class OverheatProjectile
extends AbilityProjectileEntity {
    public OverheatProjectile(EntityType type, World world) {
        super(type, world);
    }

    public OverheatProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)ItoProjectiles.OVERHEAT.get(), world, player, ability);
        this.setDamage(60.0f);
        this.setMaxLife(50);
        this.setPassThroughEntities();
        this.setCanGetStuckInGround();
        this.setDamageSource((ModDamageSource)((Object)((ModDamageSource)((Object)this.getDamageSource())).setSlash()));
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        this.onBlockImpactEvent.onImpact(hitEntity.func_233580_cy_());
        AbilityHelper.setSecondsOnFireBy((Entity)hitEntity, 10, this.getThrower());
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 4.0f);
        explosion.setStaticDamage(20.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(null);
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }
}

