/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.jiki;

import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.jiki.DamnedPunkAbility;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.JikiProjectiles;

public class DamnedPunkProjectile
extends AbilityProjectileEntity {
    private List<ItemStack> magneticItems;

    public DamnedPunkProjectile(EntityType type, World world) {
        super(type, world);
    }

    public DamnedPunkProjectile(World world, LivingEntity player, List<ItemStack> items) {
        super((EntityType)JikiProjectiles.DAMNED_PUNK.get(), world, player, DamnedPunkAbility.INSTANCE);
        this.setDamage(60.0f);
        this.setArmorPiercing(1.0f);
        this.setPassThroughEntities();
        this.magneticItems = items;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        if (this.getThrower() != null && this.getThrower() instanceof PlayerEntity) {
            JikiHelper.dropComponentItems((PlayerEntity)this.getThrower(), hit, this.magneticItems);
        }
    }
}

