/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.jiki;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.JikiProjectiles;

public class GenocideRaidEffectEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private LivingEntity owner;
    private LivingEntity target;
    private List<ItemStack> magneticItems = new ArrayList<ItemStack>();

    public GenocideRaidEffectEntity(EntityType type, World world) {
        super(type, world);
        this.func_189654_d(true);
    }

    public GenocideRaidEffectEntity(World level) {
        super((EntityType)JikiProjectiles.GENOCIDE_RAID_EFFECT.get(), level);
        this.func_189654_d(true);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > 100) {
                this.func_174812_G();
                return;
            }
            if (this.owner == null) {
                this.func_70106_y();
                return;
            }
            if (this.target == null || !this.target.func_70089_S()) {
                this.func_174812_G();
                return;
            }
            this.func_70634_a(this.target.func_226277_ct_(), this.target.func_226278_cu_() + 1.0, this.target.func_226281_cx_());
        }
        super.func_70071_h_();
    }

    public void func_174812_G() {
        if (this.owner != null) {
            ItemStack stack = this.magneticItems.get(0);
            ItemsHelper.itemBreakParticles(this.field_70170_p, this.func_213303_ch(), 20, stack);
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187635_cQ, this.func_184176_by(), 0.5f, 1.0f);
            JikiHelper.dropComponentItems(this.owner, this.func_213303_ch(), this.magneticItems);
        }
        super.func_174812_G();
    }

    protected void func_70037_a(CompoundNBT pCompound) {
    }

    protected void func_213281_b(CompoundNBT pCompound) {
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setItemsUsed(List<ItemStack> items) {
        Collections.shuffle(items);
        this.magneticItems = items;
    }

    public List<ItemStack> getItemsUsed() {
        return this.magneticItems;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.target != null ? this.target.func_145782_y() : -1);
        buffer.writeInt(this.magneticItems.size());
        for (ItemStack stack : this.magneticItems) {
            buffer.writeItemStack(stack, true);
        }
    }

    public void readSpawnData(PacketBuffer buffer) {
        Entity target;
        int targetId = buffer.readInt();
        if (targetId >= 0 && (target = this.field_70170_p.func_73045_a(targetId)) != null && target instanceof LivingEntity) {
            this.target = (LivingEntity)target;
        }
        int size = buffer.readInt();
        this.magneticItems.clear();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = buffer.func_150791_c();
            this.magneticItems.add(stack);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

