/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.mera;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.SnowLayerBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DaiEnkaiEnteiProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(LiquidBlockProtectionRule.INSTANCE, SnowLayerBlockProtectionRule.INSTANCE).build();

    public DaiEnkaiEnteiProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public DaiEnkaiEnteiProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)MeraProjectiles.DAI_ENKAI_ENTEI.get(), world, player, ability.getCore());
        super.setBlocksAffectedLimit(42875);
        super.setArmorPiercing(0.75f);
        super.setUnavoidable();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    public void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)super.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 0.6f * this.getSize());
        explosion.setStaticDamage(2.0f * this.getSize());
        explosion.setStaticBlockResistance(0.25f);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)(0.6f * this.getSize())));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        super.setDamage(2.0f * this.getSize());
        if (super.func_208600_a((ITag)FluidTags.field_206959_a) && CommonConfig.INSTANCE.getDestroyWater()) {
            List<BlockPos> coords = AbilityHelper.createFilledSphere(super.func_130014_f_(), (int)super.func_226277_ct_(), (int)super.func_226278_cu_(), (int)super.func_226281_cx_(), 9, Blocks.field_150350_a, GRIEF_RULE);
            for (BlockPos blockPos : coords) {
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197612_e, (ServerWorld)super.func_130014_f_(), (double)blockPos.func_177958_n() + WyHelper.randomDouble() / 2.0, (double)blockPos.func_177956_o() + 0.8, (double)blockPos.func_177952_p() + WyHelper.randomDouble() / 2.0);
                super.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 1.1, (double)blockPos.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            SimpleParticleData data;
            double offsetZ;
            double offsetY;
            int i;
            for (i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomDouble();
                offsetY = WyHelper.randomDouble();
                offsetZ = WyHelper.randomDouble();
                data = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                data.setLife(6);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + offsetY, super.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble();
                offsetY = WyHelper.randomDouble();
                offsetZ = WyHelper.randomDouble();
                data = new SimpleParticleData((ParticleType)ModParticleTypes.MOKU.get());
                data.setLife(4);
                data.setSize(1.2f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + offsetY, super.func_226281_cx_() + offsetZ);
            }
        }
    }

    @Override
    public float getSize() {
        return (float)super.func_174813_aQ().func_72320_b() * 4.0f;
    }

    public void increaseSize() {
        float size = (float)super.func_174813_aQ().func_72320_b() + 0.0625f;
        super.setEntityCollisionSize(size);
    }
}

