/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.mera;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HiganProjectile
extends AbilityProjectileEntity {
    public HiganProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public HiganProjectile(World world, LivingEntity thrower, Ability ability) {
        super((EntityType)MeraProjectiles.HIGAN.get(), world, thrower, ability.getCore());
        super.setDamage(10.0f);
        super.setArmorPiercing(0.75f);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        AbilityHelper.setSecondsOnFireBy((Entity)hitEntity, 4, this.getThrower());
    }

    private void onBlockImpactEvent(BlockPos hit) {
        BlockState state = this.field_70170_p.func_180495_p(hit);
        if (state.func_177230_c() == Blocks.field_222433_lV) {
            this.field_70170_p.func_180501_a(hit, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
        } else {
            AbilityHelper.placeBlockIfAllowed(this.getThrower(), hit.func_177982_a(0, 1, 0), Blocks.field_150480_ab.func_176223_P(), AirBlockProtectionRule.INSTANCE);
        }
    }

    private void onTickEvent() {
        if (super.func_208600_a((ITag)FluidTags.field_206959_a)) {
            super.func_70106_y();
            super.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, super.func_226277_ct_(), super.func_226278_cu_() + 1.1, super.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                data.setLife(10);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + 0.25 + offsetY, super.func_226281_cx_() + offsetZ);
            }
        }
    }
}

