/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.netsu;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.netsu.NetsuEnhancementAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.netsu.NetsuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NekkaiGyoraiProjectile
extends AbilityProjectileEntity {
    private int damage = 10;

    public NekkaiGyoraiProjectile(EntityType type, World world) {
        super(type, world);
    }

    public NekkaiGyoraiProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)NetsuProjectiles.NEKKAI_GYORAI.get(), world, player, ability);
        IAbilityData abilityProps = AbilityDataCapability.get(player);
        NetsuEnhancementAbility netsuAbility = abilityProps.getEquippedAbility(NetsuEnhancementAbility.INSTANCE);
        if (netsuAbility != null && netsuAbility.isContinuous()) {
            this.damage += 5;
        }
        this.setDamage(this.damage);
        this.setMaxLife(30);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_70015_d(4);
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed(this.getThrower(), hit.func_177982_a(0, 1, 0), Blocks.field_150480_ab.func_176223_P(), AirBlockProtectionRule.INSTANCE);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                ParticleType particle = (ParticleType)ModParticleTypes.NETSU.get();
                if (i % 3 == 0) {
                    particle = (ParticleType)ModParticleTypes.NETSU2.get();
                }
                if (i % 7 == 0) {
                    particle = (ParticleType)ModParticleTypes.MERA.get();
                }
                SimpleParticleData data = new SimpleParticleData(particle);
                data.setLife(10);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

