/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.NikyuProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PadHoProjectile
extends AbilityProjectileEntity {
    public PadHoProjectile(EntityType type, World world) {
        super(type, world);
    }

    public PadHoProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)NikyuProjectiles.PAD_HO.get(), world, player, ability);
        this.setDamage(15.0f);
        this.setArmorPiercing(1.0f);
        this.setPassThroughEntities();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity target) {
        this.onBlockImpactEvent.onImpact(target.func_233580_cy_());
        if (this.getDamage() > 10.0f) {
            Vector3d speed = target.func_70040_Z().func_216372_d(-1.0, -1.0, -1.0).func_216372_d(WyHelper.randomWithRange(4, 6), WyHelper.randomWithRange(1, 3), WyHelper.randomWithRange(4, 6));
            AbilityHelper.setDeltaMovement((Entity)target, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
            target.field_70143_R = 0.0f;
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), this.getDamage() / 5.0f);
        explosion.setStaticDamage(this.getDamage() / 3.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }
}

