/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.pero;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.pero.PeroProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CandyWaveProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE).build();

    public CandyWaveProjectile(EntityType type, World world) {
        super(type, world);
    }

    public CandyWaveProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)PeroProjectiles.CANDY_WAVE.get(), world, player, ability);
        this.setDamage(24.0f);
        this.setMaxLife(12);
        this.setPassThroughEntities();
        this.setPassThroughBlocks();
        this.withEffects = () -> new EffectInstance[]{new EffectInstance((Effect)ModEffects.CANDY_STUCK.get(), 100, 0, false, false, false)};
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_233580_cy_().func_177979_c(j);
                break;
            }
            if (j > 3) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        int size = 2 + 4 * (this.getMaxLife() - this.getLife()) / this.getMaxLife();
        AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size, (Block)ModBlocks.CANDY.get(), GRIEF_RULE);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CANDY_WAVE.get(), (Entity)this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

