/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.zoan;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFourthAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFourthFlightAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.models.morphs.GearFourthModel;
import xyz.pixelatedw.mineminenomi.renderers.morphs.GearFourthRenderer;

public class GearFourthMorphInfo
extends MorphInfo {
    private static final EntitySize STANDING_SIZE = EntitySize.func_220314_b((float)2.8f, (float)4.0f);
    private static final EntitySize CROUCHING_SIZE = EntitySize.func_220314_b((float)2.8f, (float)3.9f);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory() {
        return new GearFourthRenderer.Factory(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MorphModel getModel() {
        return new GearFourthModel(true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
        boolean isMoving;
        double x = entity.field_70169_q - entity.func_226277_ct_();
        double z = entity.field_70166_s - entity.func_226281_cx_();
        boolean bl = isMoving = x != 0.0 || z != 0.0;
        if (isMoving) {
            IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
            PropelledFlightAbility flight = abilityDataProps.getPassiveAbility(GearFourthFlightAbility.INSTANCE);
            if (flight != null && flight.getSpeed(entity) >= flight.getMaxSpeed(entity) * 0.5f) {
                float headYawOffset = MathHelper.func_219805_h((float)partialTickTime, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
                float headYawRotation = MathHelper.func_219805_h((float)partialTickTime, (float)entity.field_70758_at, (float)entity.field_70759_as);
                float netHeadYaw = headYawRotation - headYawOffset;
                double distanceX = entity.func_226277_ct_() - entity.field_70169_q;
                double distanceZ = entity.func_226281_cx_() - entity.field_70166_s;
                double movementSpeed = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
                float maxRotation = (float)(movementSpeed * 80.0);
                float rot = -netHeadYaw * 3.0f;
                rot = MathHelper.func_76131_a((float)rot, (float)(-maxRotation), (float)maxRotation);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rot));
            }
            matrixStack.func_227861_a_(0.0, -2.0, 2.0 * (double)entity.field_191988_bg);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entity.field_70125_A + 90.0f * entity.field_191988_bg));
        }
    }

    @Override
    public ResourceLocation getTexture(LivingEntity entity) {
        if (entity instanceof AbstractClientPlayerEntity) {
            return ((AbstractClientPlayerEntity)entity).func_110306_p();
        }
        return null;
    }

    @Override
    public AkumaNoMiItem getDevilFruit() {
        return ModAbilities.GOMU_GOMU_NO_MI;
    }

    @Override
    public String getForm() {
        return "gear_4th";
    }

    @Override
    public String getDisplayName() {
        return GearFourthAbility.INSTANCE.getUnlocalizedName();
    }

    @Override
    public double getEyeHeight() {
        return 4.0;
    }

    @Override
    public float getShadowSize() {
        return 1.2f;
    }

    @Override
    public Map<Pose, EntitySize> getSizes() {
        return ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.CROUCHING, (Object)CROUCHING_SIZE).build();
    }
}

