/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.zoan;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.abilities.karu.IngaZarashiAbility;
import xyz.pixelatedw.mineminenomi.abilities.karu.KarmaAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.renderers.morphs.ModifiedPlayerRenderer;

public class IngaZarashiMorphInfo
extends MorphInfo {
    private float karma = 0.0f;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory(LivingEntity entity) {
        KarmaAbility abl = AbilityDataCapability.get(entity).getEquippedOrPassiveAbility(KarmaAbility.INSTANCE);
        if (abl != null) {
            this.karma = abl.getKarma();
        }
        boolean isSlim = false;
        if (entity instanceof AbstractClientPlayerEntity) {
            isSlim = ((AbstractClientPlayerEntity)entity).func_175154_l().equals("slim");
        }
        return new ModifiedPlayerRenderer.Factory(this, isSlim, 1.0f + this.karma / 60.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MorphModel getModel() {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFirstPersonHand() {
        return true;
    }

    @Override
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
    }

    @Override
    public AkumaNoMiItem getDevilFruit() {
        return ModAbilities.KARU_KARU_NO_MI;
    }

    @Override
    public String getForm() {
        return "karu";
    }

    @Override
    public String getDisplayName() {
        return IngaZarashiAbility.INSTANCE.getUnlocalizedName();
    }

    @Override
    public double getEyeHeight() {
        return 1.85 + (double)(this.karma / 30.0f);
    }

    @Override
    public float getShadowSize() {
        return 0.5f + this.karma / 50.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public double getCameraHeight(LivingEntity entity) {
        boolean shouldSit;
        boolean isFirstPerson = Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON;
        boolean bl = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        if (isFirstPerson && shouldSit) {
            return 0.5;
        }
        return 0.0;
    }

    @Override
    public Map<Pose, EntitySize> getSizes() {
        return ImmutableMap.builder().put((Object)Pose.STANDING, (Object)EntitySize.func_220314_b((float)(0.6f + this.karma / 60.0f), (float)(1.8f + this.karma / 30.0f))).put((Object)Pose.CROUCHING, (Object)EntitySize.func_220314_b((float)(0.6f + this.karma / 60.0f), (float)(1.6f + this.karma / 30.0f))).build();
    }
}

