/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.zoan;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.abilities.kage.ShadowsAsgardAbility;
import xyz.pixelatedw.mineminenomi.abilities.karu.IngaZarashiAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.renderers.morphs.ModifiedPlayerRenderer;

public class ShadowsAsgardMorphInfo
extends MorphInfo {
    private int cachedShadow;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory(LivingEntity entity) {
        boolean isSlim = false;
        if (entity instanceof AbstractClientPlayerEntity) {
            isSlim = ((AbstractClientPlayerEntity)entity).func_175154_l().equals("slim");
        }
        return new ModifiedPlayerRenderer.Factory(this, isSlim, 1.0f + (float)this.cachedShadow / 60.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MorphModel getModel() {
        return null;
    }

    @Override
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
    }

    @Override
    public AkumaNoMiItem getDevilFruit() {
        return ModAbilities.KARU_KARU_NO_MI;
    }

    @Override
    public String getForm() {
        return "karu";
    }

    @Override
    public String getDisplayName() {
        return IngaZarashiAbility.INSTANCE.getUnlocalizedName();
    }

    @Override
    public double getEyeHeight() {
        return 1.85 + (double)((float)this.cachedShadow / 30.0f);
    }

    @Override
    public float getShadowSize() {
        return 0.5f + (float)this.cachedShadow / 50.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public double getCameraHeight(LivingEntity entity) {
        boolean shouldSit;
        this.updateShadows(entity);
        boolean isFirstPerson = Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON;
        boolean bl = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        if (isFirstPerson && shouldSit) {
            return 0.5;
        }
        return 0.0;
    }

    @Override
    public Map<Pose, EntitySize> getSizes() {
        return ImmutableMap.builder().put((Object)Pose.STANDING, (Object)EntitySize.func_220314_b((float)(0.6f + (float)this.cachedShadow / 60.0f), (float)(1.8f + (float)this.cachedShadow / 30.0f))).put((Object)Pose.CROUCHING, (Object)EntitySize.func_220314_b((float)(0.6f + (float)this.cachedShadow / 60.0f), (float)(1.6f + (float)this.cachedShadow / 30.0f))).build();
    }

    private void updateShadows(LivingEntity entity) {
        if (this.cachedShadow == 0 || entity.field_70173_aa % 20 == 0) {
            this.cachedShadow = AbilityDataCapability.get(entity).getEquippedAbility(ShadowsAsgardAbility.INSTANCE).getShadows();
        }
    }
}

