/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.abilities.EmptyHandsAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PauseTickComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SlotDecorationComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.effects.HandcuffedEffect;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModKeybindings;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CombatModeEvents {

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class Common {
        @SubscribeEvent
        public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
            PlayerEntity player = event.getPlayer();
            if (!player.field_70170_p.field_72995_K && WyHelper.isInChallengeDimension(player.field_70170_p)) {
                ItemStack stack = event.getItemStack();
                ChallengesWorldData worldData = ChallengesWorldData.get();
                InProgressChallenge challenge = worldData.getInProgressChallengeFor((LivingEntity)player);
                if (challenge != null) {
                    boolean isFood = stack.func_77973_b().func_219971_r();
                    boolean isPotion = stack.func_77973_b() instanceof PotionItem;
                    boolean hasRestrictions = challenge.hasRestrictions() && challenge.hasActiveRestrictions() && (isFood || isPotion);
                    boolean isItemBanned = stack.func_77973_b().func_206844_a(ModTags.Items.BANNED_ITEMS_CHALLANGES);
                    if (hasRestrictions || isItemBanned) {
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)ModI18n.CHALLENGE_MESSAGE_CANNOT_USE_ITEM, Util.field_240973_b_);
                        }
                        event.setCanceled(true);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onCarryUpdate(LivingEvent.LivingUpdateEvent event) {
            LivingEntity living = event.getEntityLiving();
            if (living.field_70170_p.field_72995_K) {
                return;
            }
            IEntityStats props = EntityStatsCapability.get(living);
            if (living instanceof PlayerEntity && props.isLeashed()) {
                float distance;
                boolean isHandcuffed = false;
                for (EffectInstance effect : living.func_70651_bq()) {
                    if (!(effect.func_188419_a() instanceof HandcuffedEffect)) continue;
                    isHandcuffed = true;
                    break;
                }
                if (!isHandcuffed) {
                    props.dropLeash();
                    return;
                }
                LivingEntity leashHolder = props.getLeashHolder();
                if (leashHolder != null && (distance = living.func_70032_d((Entity)leashHolder)) > 6.0f) {
                    double x = (leashHolder.func_226277_ct_() - living.func_226277_ct_()) / (double)distance;
                    double y = (leashHolder.func_226278_cu_() - living.func_226278_cu_()) / (double)distance;
                    double z = (leashHolder.func_226281_cx_() - living.func_226281_cx_()) / (double)distance;
                    if (!living.func_233570_aj_()) {
                        x /= 1.75;
                        y /= 1.75;
                        z /= 1.75;
                    }
                    AbilityHelper.setDeltaMovement((Entity)living, x, y, z);
                }
            }
            if (props.isCarrying()) {
                LivingEntity target = props.getCarry();
                if (target == null || !target.func_70089_S() || !AbilityHelper.canCarry(living, target)) {
                    props.stopCarrying();
                    return;
                }
                living.func_195064_c(new EffectInstance((Effect)ModEffects.CARRYING.get(), 40, 0));
                AbilityHelper.setDeltaMovement((Entity)target, Vector3d.field_186680_a);
                target.func_70634_a(living.func_226277_ct_(), living.func_226280_cw_() + 0.75, living.func_226281_cx_());
                target.field_70143_R = 0.0f;
            }
        }

        @SubscribeEvent
        public static void onEntityDrop(PlayerInteractEvent event) {
            PlayerEntity player;
            IEntityStats props;
            if (event.getHand().equals((Object)Hand.MAIN_HAND) && !event.getPlayer().field_70170_p.field_72995_K && (props = EntityStatsCapability.get((LivingEntity)(player = event.getPlayer()))).isCarrying()) {
                LivingEntity target = props.getCarry();
                props.stopCarrying();
                if (target != null) {
                    if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
                        Entity interactionEntity = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget();
                        if (interactionEntity != null && interactionEntity instanceof BoatEntity) {
                            target.func_184220_m(interactionEntity);
                            event.setCanceled(true);
                        }
                    } else {
                        target.func_70107_b(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_());
                        AbilityHelper.setDeltaMovement((Entity)target, player.func_70040_Z().func_216372_d(0.5, 1.0, 0.5));
                        event.setCanceled(true);
                    }
                }
            }
        }

        public static boolean tryLeashTarget(PlayerEntity player, PlayerEntity target) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            IEntityStats targetProps = EntityStatsCapability.get((LivingEntity)target);
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151058_ca && targetProps.canBeLeashed((LivingEntity)player)) {
                boolean isHandcuffed = false;
                for (EffectInstance effect : target.func_70651_bq()) {
                    if (!(effect.func_188419_a() instanceof HandcuffedEffect)) continue;
                    isHandcuffed = true;
                    break;
                }
                if (isHandcuffed) {
                    targetProps.setLeashedTo((LivingEntity)player);
                    stack.func_190918_g(1);
                    return true;
                }
            }
            return false;
        }

        public static boolean tryPickupTarget(PlayerEntity player, LivingEntity target) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            IEntityStats targetProps = EntityStatsCapability.get(target);
            if (target instanceof PlayerEntity && targetProps.isLeashed() && targetProps.getLeashHolder().equals((Object)player)) {
                targetProps.dropLeash();
                return true;
            }
            if (!props.isCarrying() && AbilityHelper.canCarry((LivingEntity)player, target)) {
                props.startCarrying(target);
                return true;
            }
            return false;
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onItemPickup(EntityItemPickupEvent event) {
            PlayerEntity player = event.getPlayer();
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_190926_b()) {
                EmptyHandsAbility abl;
                IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
                boolean isEmptyHandsActive = false;
                if (props != null && (abl = props.getPassiveAbility(EmptyHandsAbility.INSTANCE)) != null) {
                    boolean bl = isEmptyHandsActive = !abl.getComponent(ModAbilityKeys.PAUSE_TICK).get().isPaused();
                }
                if (isEmptyHandsActive) {
                    ItemEntity itemEntity = event.getItem();
                    ItemStack itemstack = itemEntity.func_92059_d();
                    Item item = itemstack.func_77973_b();
                    int i = itemstack.func_190916_E();
                    int emptySlot = ItemsHelper.getFreeOrSameSlot(player, itemstack);
                    if (emptySlot < 0) {
                        event.setCanceled(true);
                        return;
                    }
                    ItemStack copy = itemstack.func_77946_l();
                    if (!(itemEntity.func_174874_s() || itemEntity.func_200215_l() != null && itemEntity.lifespan - itemEntity.func_174872_o() > 200 && !itemEntity.func_200215_l().equals(player.func_110124_au()) || i > 0 && !player.field_71071_by.func_191971_c(emptySlot, itemstack))) {
                        copy.func_190920_e(copy.func_190916_E() - itemEntity.func_92059_d().func_190916_E());
                        BasicEventHooks.firePlayerItemPickupEvent((PlayerEntity)player, (ItemEntity)itemEntity, (ItemStack)copy);
                        player.func_71001_a((Entity)itemEntity, i);
                        if (itemstack.func_190926_b()) {
                            itemEntity.func_70106_y();
                            itemstack.func_190920_e(i);
                        }
                        player.func_71064_a(Stats.field_199089_f.func_199076_b((Object)item), i);
                        player.func_233630_a_(itemEntity);
                        event.setCanceled(true);
                        return;
                    }
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class Client {
        public static int ABILITY_BARS = CommonConfig.INSTANCE.getAbilityBars();
        private static int colorTicks = 1000;
        public static boolean isInCombat;
        private static int iconSum;
        private static int iconMode;
        private static final List<Supplier<Effect>> FOV_EFFECTS;

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            int posX = mc.func_228018_at_().func_198107_o();
            int posY = mc.func_228018_at_().func_198087_p();
            if (abilityDataProps == null) {
                return;
            }
            if (ClientConfig.INSTANCE.hasHeartsUI()) {
                ++ForgeIngameGui.left_height;
            }
            int maxBars = MathHelper.func_76125_a((int)ClientConfig.INSTANCE.getAbilityBarsOnScreen(), (int)1, (int)ABILITY_BARS);
            int offset = (maxBars - 1) * 23;
            iconSum = 0;
            if (isInCombat) {
                ++iconSum;
            }
            if (entityStatsProps.isRogue()) {
                iconSum += 2;
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && iconSum != 0 && !player.func_184812_l_() && !player.func_175149_v()) {
                if (iconSum == 3) {
                    if (iconMode == 0) {
                        iconMode = iconSum % 2;
                    }
                    if (player.field_70173_aa % 40 == 0) {
                        if (iconMode == 1) {
                            iconMode = 2;
                        } else if (iconMode == 2) {
                            iconMode = 1;
                        }
                    }
                } else {
                    iconMode = iconSum % 3;
                }
                if (iconMode > 0) {
                    int offsetIcon;
                    int n = offsetIcon = entityStatsProps.isInCombatMode() ? offset : 0;
                    if (iconMode == 1) {
                        mc.func_110434_K().func_110577_a(ModResources.PIRATE_ICON);
                    } else if (iconMode == 2) {
                        mc.func_110434_K().func_110577_a(ModResources.WARNING_ICON);
                    }
                    event.getMatrixStack().func_227860_a_();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    event.getMatrixStack().func_227861_a_((double)(posX / 2 - 128), (double)(posY - 170 - offsetIcon), 2.0);
                    event.getMatrixStack().func_227861_a_(128.0, 128.0, 0.0);
                    event.getMatrixStack().func_227862_a_(0.15f, 0.15f, 1.0f);
                    event.getMatrixStack().func_227861_a_(-128.0, -128.0, 0.0);
                    RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GuiUtils.drawTexturedModalRect((MatrixStack)event.getMatrixStack(), (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                    event.getMatrixStack().func_227865_b_();
                }
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH && ClientConfig.INSTANCE.hasHeartsUI()) {
                event.setCanceled(true);
                double maxHealth = player.func_110148_a(Attributes.field_233818_a_).func_111126_e();
                double health = player.func_110143_aJ();
                int absorptionBonus = MathHelper.func_76123_f((float)player.func_110139_bj());
                int rgb = Color.RED.getRGB();
                int posY2 = posY + 9 - ForgeIngameGui.left_height;
                if (absorptionBonus > 0) {
                    rgb = Color.YELLOW.getRGB();
                }
                WyHelper.drawStringWithBorder(mc.field_71466_p, event.getMatrixStack(), (int)(health + (double)absorptionBonus) + "", posX / 2 - 27, posY2, rgb);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(Widget.field_230665_h_);
                for (int i = 10; i >= 0; --i) {
                    int k = posX / 2 - 91 + i % 10 * 6;
                    GuiUtils.drawTexturedModalRect((MatrixStack)event.getMatrixStack(), (int)k, (int)posY2, (int)16, (int)0, (int)9, (int)9, (float)0.0f);
                }
                double hpPercentage = (100.0 - (maxHealth - health) / maxHealth * 100.0) / 10.0;
                int top = 9 * (mc.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
                int anim = player.field_70173_aa % 25;
                for (int i2 = 0; i2 < 10; ++i2) {
                    int k = posX / 2 - 91 + i2 % 10 * 6;
                    int y = posY2;
                    int lastIdx = (int)Math.floor(hpPercentage);
                    int width = 9;
                    if (i2 == lastIdx) {
                        width = (int)(hpPercentage * 10.0 % 10.0);
                    } else if (i2 > lastIdx) {
                        width = 0;
                    }
                    if (lastIdx < 4 && i2 == anim) {
                        y -= 2;
                    }
                    int u = 36;
                    if (absorptionBonus > 0) {
                        u = 144;
                    }
                    GuiUtils.drawTexturedModalRect((MatrixStack)event.getMatrixStack(), (int)k, (int)y, (int)(16 + u), (int)top, (int)width, (int)9, (float)0.0f);
                }
            }
            if (!entityStatsProps.isInCombatMode()) {
                return;
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                event.getMatrixStack().func_227860_a_();
                event.getMatrixStack().func_227861_a_(0.0, (double)(-offset), 0.0);
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
                Set<IAbility> gauges = abilityDataProps.getEquippedAndPassiveAbilities(abl -> abl.getComponent(ModAbilityKeys.GAUGE).isPresent());
                int ablNo = 1;
                int posX2 = posX / 2 - 110;
                for (IAbility abl2 : gauges) {
                    Optional<GaugeComponent> comp;
                    boolean isPaused = abl2.getComponent(ModAbilityKeys.PAUSE_TICK).map(PauseTickComponent::isPaused).orElse(false);
                    if (isPaused || !(comp = abl2.getComponent(ModAbilityKeys.GAUGE)).isPresent()) continue;
                    comp.get().getRenderer().renderGauge((PlayerEntity)player, event.getMatrixStack(), posX2 - 35 * ablNo, posY, abl2);
                    ++ablNo;
                }
                boolean[] visuals = ClientConfig.INSTANCE.getCooldownVisuals();
                boolean hasNumberVisual = visuals[0];
                boolean hasColorVisual = visuals[1];
                event.setCanceled(true);
                event.getMatrixStack().func_227860_a_();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableLighting();
                RenderSystem.enableBlend();
                ForgeIngameGui.right_height += offset;
                ForgeIngameGui.left_height += offset;
                for (int bars = 0; bars < maxBars; ++bars) {
                    if (ABILITY_BARS - (abilityDataProps.getCombatBarSet() + bars) <= 0) continue;
                    String barId = 1 + (abilityDataProps.getCombatBarSet() + bars) + "";
                    WyHelper.drawStringWithBorder(mc.field_71466_p, event.getMatrixStack(), barId, posX / 2 - (mc.field_71466_p.func_78256_a(barId) + 102), posY - 14 - bars * 23, WyHelper.hexToRGB("#FFFFFF").getRGB());
                    mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
                    for (int i = 0; i < 8; ++i) {
                        int j = i + (abilityDataProps.getCombatBarSet() + bars) * 8;
                        IAbility abl3 = null;
                        try {
                            abl3 = (IAbility)abilityDataProps.getEquippedAbility(j);
                        }
                        catch (Exception i2) {
                            // empty catch block
                        }
                        RenderSystem.enableBlend();
                        if (abl3 == null) {
                            GuiUtils.drawTexturedModalRect((MatrixStack)event.getMatrixStack(), (int)((posX - 200 + i * 50) / 2), (int)(posY - 23 - bars * 23), (int)0, (int)0, (int)23, (int)23, (float)0.0f);
                            continue;
                        }
                        boolean hasDisplayText = false;
                        String displayText = "";
                        double maxNumber = 1.0;
                        double number = 0.0;
                        Optional<SlotDecorationComponent> slotDecoComponent = abl3.getComponent(ModAbilityKeys.SLOT_DECORATION);
                        if (abl3 instanceof Ability && ((Ability)abl3).isNew && slotDecoComponent.isPresent()) {
                            SlotDecorationComponent slotDeco = slotDecoComponent.get();
                            number = slotDeco.getCurrentValue();
                            maxNumber = slotDeco.getMaxValue();
                            hasDisplayText = slotDeco.hasDisplayText();
                            displayText = slotDeco.getDisplayText();
                            double slotHeight = MathHelper.func_151237_a((double)(23.0 - number / maxNumber * 23.0), (double)0.0, (double)Double.MAX_VALUE);
                            int x = (posX - 200 + i * 50) / 2;
                            int y = posY - 23 - bars * 23;
                            slotDeco.triggerPreRenderEvents((LivingEntity)player, mc, event.getMatrixStack(), x, y, event.getPartialTicks());
                            RendererHelper.drawTexturedModalRect(event.getMatrixStack(), x, y, 0.0f, 0.0f, 23.0f, 23.0f, 0.0f, slotDeco.getSlotRed(), slotDeco.getSlotGreen(), slotDeco.getSlotBlue(), 1.0f);
                            RendererHelper.drawTexturedModalRect(event.getMatrixStack(), x, y, 24.0f, 0.0f, 23.0f, (int)slotHeight, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                            RendererHelper.drawIcon(abl3.getIcon((LivingEntity)player), event.getMatrixStack(), x + 4, y + 4, 1.0f, 16.0f, 16.0f, slotDeco.getIconRed(), slotDeco.getIconGreen(), slotDeco.getIconBlue(), slotDeco.getIconAlpha());
                            slotDeco.triggerPostRenderEvents((LivingEntity)player, mc, event.getMatrixStack(), x, y, event.getPartialTicks());
                        }
                        event.getMatrixStack().func_227861_a_(0.0, 0.0, 2.0);
                        if (hasNumberVisual && number > 0.0) {
                            String numText;
                            int xTextOffset = 0;
                            if (hasDisplayText) {
                                numText = displayText;
                                xTextOffset = -2;
                            } else {
                                numText = ClientConfig.INSTANCE.isDisplayInSeconds() ? String.format("%.1f", number / 20.0) + " " : (int)number + " ";
                            }
                            WyHelper.drawStringWithBorder(mc.field_71466_p, event.getMatrixStack(), numText, (posX - 172 + xTextOffset + i * 50) / 2 - mc.field_71466_p.func_78256_a(numText) / 2, posY - 14 - bars * 23, WyHelper.hexToRGB("#FFFFFF").getRGB());
                        }
                        if (ClientConfig.INSTANCE.showSlotKeybinds()) {
                            int keybindSlot = i + bars * 8;
                            KeyBinding kb = ModKeybindings.keyBindsCombatbar.get(keybindSlot);
                            StringBuilder sb = new StringBuilder();
                            colorTicks = (colorTicks + 1) % 2000;
                            if (kb.func_197986_j()) {
                                sb.append(colorTicks >= 1000 ? "\u00a74" : "\u00a7c");
                                sb.append("\u26a0");
                            } else {
                                if (ModKeybindings.isHotbarKeyConflicting(kb)) {
                                    sb.append(colorTicks >= 1000 ? "\u00a74" : "\u00a7c");
                                }
                                switch (kb.getKeyModifier()) {
                                    case ALT: {
                                        sb.append("a");
                                        break;
                                    }
                                    case CONTROL: {
                                        sb.append("c");
                                        break;
                                    }
                                    case SHIFT: {
                                        sb.append("s");
                                        break;
                                    }
                                }
                                sb.append(kb.getKey().func_237520_d_().getString());
                            }
                            event.getMatrixStack().func_227860_a_();
                            event.getMatrixStack().func_227861_a_((double)((posX - 195 + i * 50) / 2), (double)(posY - 8 - bars * 23), 0.0);
                            event.getMatrixStack().func_227862_a_(0.66f, 0.66f, 0.66f);
                            WyHelper.drawStringWithBorder(mc.field_71466_p, event.getMatrixStack(), sb.toString(), 0, 0, -1);
                            event.getMatrixStack().func_227865_b_();
                        }
                        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
                        RenderSystem.disableBlend();
                    }
                }
                event.getMatrixStack().func_227865_b_();
                RenderSystem.disableBlend();
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            if (!entityStatsProps.isInCombatMode()) {
                return;
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                event.getMatrixStack().func_227865_b_();
            }
        }

        @SubscribeEvent
        public static void updateFOV(FOVUpdateEvent event) {
            if (FOV_EFFECTS.stream().anyMatch(f -> event.getEntity().func_70644_a((Effect)f.get()))) {
                event.setNewfov(1.0f);
            }
        }

        static {
            iconSum = 0;
            iconMode = 0;
            FOV_EFFECTS = Arrays.asList(ModEffects.PARALYSIS, ModEffects.GUARDING, ModEffects.MOVEMENT_BLOCKED, ModEffects.CANDLE_LOCK);
        }
    }
}

