/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IHitAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.IChallengeBoss;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.enums.HandcuffType;
import xyz.pixelatedw.mineminenomi.api.enums.NetType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.ProjectileExtrasCapability;
import xyz.pixelatedw.mineminenomi.effects.CaughtInNetEffect;
import xyz.pixelatedw.mineminenomi.effects.HandcuffedEffect;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.items.HandcuffsItem;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.packets.server.SSetEffectDetailsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class DamageCalcsEvents {
    public static float calcExtraDamage(LivingEntity target, DamageSource source, Entity directEntity, float amount) {
        LivingEntity livingAttacker;
        boolean result;
        if (directEntity != null && directEntity instanceof LivingEntity && (result = DamageCalcsEvents.handleHandcuffActivation(livingAttacker = (LivingEntity)directEntity, target, amount))) {
            return -1.0f;
        }
        DamageCalcsEvents.handleArmorConductivity(target, source);
        amount = DamageCalcsEvents.handleEntityConductivity((Entity)target, source, amount);
        amount = DamageCalcsEvents.calcDamageReduction(target, source, amount);
        DamageCalcsEvents.handleHandcuffDamage(target, amount);
        return amount;
    }

    private static float calcDamageReduction(LivingEntity target, DamageSource source, float initialDamage) {
        if (source.func_76357_e()) {
            return initialDamage;
        }
        ModifiableAttributeInstance damageReductionAttribute = target.func_110148_a((Attribute)ModAttributes.DAMAGE_REDUCTION.get());
        ModifiableAttributeInstance fauxProtectionAttribute = target.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get());
        ModifiableAttributeInstance toughnessAttribute = target.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get());
        ModifiableAttributeInstance armorAttribute = target.func_110148_a(Attributes.field_233826_i_);
        Entity sourceEntity = source.func_76346_g();
        Entity directEntity = source.func_76364_f();
        if (toughnessAttribute == null || armorAttribute == null) {
            return initialDamage;
        }
        if (sourceEntity instanceof PlayerEntity) {
            Predicate<IAbility> hitAbilityCheck = a -> a instanceof IHitAbility && ((IHitAbility)((Object)a)).isActive((PlayerEntity)sourceEntity);
            for (IAbility ability : AbilityDataCapability.get((LivingEntity)((PlayerEntity)sourceEntity)).getEquippedAbilities(hitAbilityCheck)) {
                DamageSource punchSource = ((IHitAbility)((Object)ability)).getDamageSource((PlayerEntity)sourceEntity, null);
                if (!(punchSource instanceof ModDamageSource)) continue;
                DamageCalcsEvents.handleArmorConductivity(target, punchSource);
                initialDamage = DamageCalcsEvents.handleEntityConductivity((Entity)target, punchSource, initialDamage);
            }
        }
        float piercing = 0.0f;
        if (directEntity instanceof ProjectileEntity) {
            piercing = ProjectileExtrasCapability.get(directEntity).getPiercing();
        }
        if (source instanceof ModDamageSource) {
            source.func_76348_h();
            ModDamageSource modSource = (ModDamageSource)source;
            initialDamage = DamageCalcsEvents.handleWeaponConductivity(modSource, initialDamage);
            if (modSource.getPierce() == 1.0f) {
                source.func_76348_h();
            }
            piercing = modSource.getPierce();
        }
        double toughness = toughnessAttribute.func_111126_e() * 1.28;
        double armor = armorAttribute.func_111126_e() * 0.72 * (1.0 - (double)piercing);
        double totalDef = Math.min((toughness + armor) / 40.0, 1.0);
        float totalReduction = (float)((double)initialDamage * totalDef * 0.95);
        if (target instanceof IChallengeBoss) {
            float finalDamageAfterProt = CombatRules.func_188401_b((float)(initialDamage - totalReduction), (float)((float)fauxProtectionAttribute.func_111126_e()));
            return finalDamageAfterProt;
        }
        float damageAfterToughness = initialDamage - totalReduction;
        if (damageReductionAttribute != null && damageReductionAttribute.func_111126_e() != 0.0) {
            damageAfterToughness = (float)((double)damageAfterToughness * (1.0 - damageReductionAttribute.func_111126_e()));
        }
        return damageAfterToughness;
    }

    private static void handleArmorConductivity(LivingEntity target, DamageSource source) {
        if (!(source instanceof ModDamageSource)) {
            return;
        }
        ModDamageSource modSource = (ModDamageSource)source;
        if (modSource.getElement() != SourceElement.LIGHTNING) {
            return;
        }
        for (ItemStack itemStack : target.func_184193_aE()) {
            float conductivity = ModTags.Items.CONDUCTIVE.getValue(itemStack.func_77973_b());
            if (!(conductivity > 0.0f)) continue;
            modSource.setPiercing(modSource.getPierce() + conductivity);
        }
    }

    private static float handleEntityConductivity(Entity entity, DamageSource source, float damage) {
        if (!(source instanceof ModDamageSource)) {
            return damage;
        }
        ModDamageSource modSource = (ModDamageSource)source;
        if (modSource.getElement() != SourceElement.LIGHTNING) {
            return damage;
        }
        float conductivity = ModTags.Entities.CONDUCTIVE.getValue(entity.func_200600_R());
        return damage + damage * conductivity;
    }

    private static float handleWeaponConductivity(DamageSource source, float damage) {
        if (!(source instanceof ModDamageSource)) {
            return damage;
        }
        ModDamageSource modSource = (ModDamageSource)source;
        if (modSource.getElement() != SourceElement.LIGHTNING) {
            return damage;
        }
        float conductivity = 0.0f;
        if (modSource.hasType(SourceType.PROJECTILE)) {
            conductivity = ModTags.Entities.CONDUCTIVE.getValue(source.func_76364_f().func_200600_R());
        } else if (modSource.isPhysical() && !modSource.isFistDamage()) {
            LivingEntity attacker = (LivingEntity)source.func_76346_g();
            conductivity = attacker.func_184614_ca().func_190926_b() ? 1.0f : ModTags.Items.CONDUCTIVE.getValue(attacker.func_184614_ca().func_77973_b());
        } else {
            return damage;
        }
        return damage * conductivity;
    }

    private static void handleHandcuffDamage(LivingEntity entity, float damage) {
        for (EffectInstance effectInstance : entity.func_70651_bq()) {
            PlayerEntity player;
            int newDur;
            int dur;
            if (effectInstance.func_188419_a() instanceof HandcuffedEffect) {
                dur = effectInstance.func_76459_b();
                newDur = (int)((float)dur - damage * 30.0f);
                ((EffectInstanceMixin)effectInstance).setDuration(newDur);
                WyNetwork.sendToAllTrackingAndSelf(new SSetEffectDetailsPacket(entity.func_145782_y(), effectInstance), (Entity)entity);
                if (effectInstance.func_76459_b() <= 1 && ((HandcuffedEffect)effectInstance.func_188419_a()).getType() == HandcuffType.KAIROSEKI && entity instanceof PlayerEntity) {
                    player = (PlayerEntity)entity;
                    AbilityHelper.enableAbilities((LivingEntity)player, ability -> ability.getCore().getCategory() == AbilityCategory.DEVIL_FRUITS);
                }
            }
            if (!(effectInstance.func_188419_a() instanceof CaughtInNetEffect)) continue;
            dur = effectInstance.func_76459_b();
            newDur = (int)((float)dur - damage * 50.0f);
            ((EffectInstanceMixin)effectInstance).setDuration(newDur);
            WyNetwork.sendToAllTrackingAndSelf(new SSetEffectDetailsPacket(entity.func_145782_y(), effectInstance), (Entity)entity);
            if (effectInstance.func_76459_b() > 1 || ((CaughtInNetEffect)effectInstance.func_188419_a()).getType() != NetType.KAIROSEKI || !(entity instanceof PlayerEntity)) continue;
            player = (PlayerEntity)entity;
            AbilityHelper.enableAbilities((LivingEntity)player, ability -> ability.getCore().getCategory() == AbilityCategory.DEVIL_FRUITS);
        }
    }

    private static boolean handleHandcuffActivation(LivingEntity entity, LivingEntity target, float damage) {
        if (damage <= 0.0f || target.func_110143_aJ() - damage > 0.0f) {
            return false;
        }
        return HandcuffsItem.handleHandcuffActivation(entity.func_184592_cb(), target, damage);
    }
}

