/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.abilities.haki.HaoshokuHakiInfusionAbility;
import xyz.pixelatedw.mineminenomi.api.ISweep;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.effects.IBreakableEffect;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.events.HitTriggerBlockedEvent;
import xyz.pixelatedw.mineminenomi.api.events.HitTriggerEvent;
import xyz.pixelatedw.mineminenomi.api.events.ProjectileHitEvent;
import xyz.pixelatedw.mineminenomi.api.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingAttackEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingDamageEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingHurtEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.events.DamageCalcsEvents;
import xyz.pixelatedw.mineminenomi.events.EffectsEvents;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilitiesEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenCharacterCreatorScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class FactionEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttack(WyLivingAttackEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        DamageSource source = event.getSource();
        Entity sourceEntity = source.func_76346_g();
        LivingEntity target = event.getEntityLiving();
        float amount = event.getAmount();
        ProtectedArea area = ProtectedAreasData.get(target.field_70170_p).getProtectedArea((int)target.func_226277_ct_(), (int)target.func_226278_cu_(), (int)target.func_226281_cx_());
        if (area != null) {
            boolean canBypass;
            boolean bl = canBypass = source instanceof ModDamageSource && ((ModDamageSource)source).canBypassFriendlyDamage();
            if (!area.canHurtEntities() && !canBypass) {
                event.setCanceled(true);
                return;
            }
        }
        if (FactionEvents.isDamageSourceBlockedByShield(source, target)) {
            ItemsHelper.hurtCurrentlyUsedShield(target, amount);
            if (sourceEntity != null) {
                target.func_233627_a_(0.5f, sourceEntity.func_226277_ct_() - target.func_226277_ct_(), sourceEntity.func_226281_cx_() - target.func_226281_cx_());
                target.field_70133_I = true;
            }
            event.setCanceled(true);
            return;
        }
        if (!(!(sourceEntity instanceof LivingEntity) || source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w())) {
            LivingEntity attacker = (LivingEntity)sourceEntity;
            FriendlyFireHitResult result = FactionEvents.tryFriendlyFireHit(attacker, target, source, amount);
            if (result.cancel) {
                event.setCanceled(true);
                return;
            }
            source = result.source;
            amount = result.damage;
            event.setSource(source);
            event.setAmount(amount);
        } else if (sourceEntity == null) {
            boolean isBlocked;
            float damageTaken = AbilitiesEvents.handleDamageTakenComponents(target, source, event.getAmount(), DamageTakenComponent.DamageState.ATTACK);
            event.setAmount(damageTaken);
            boolean bl = isBlocked = damageTaken <= 0.0f;
            if (isBlocked) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (ModMain.hasShitInstalled()) {
            WyLivingHurtEvent newEvent = new WyLivingHurtEvent(event.getEntityLiving(), event.getSource(), event.getAmount());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
            if (Float.isNaN(newEvent.getAmount())) {
                return;
            }
            if (!newEvent.isCanceled()) {
                ModDamageSource newSource = new ModDamageSource(newEvent.getSource());
                newSource.ignore();
                event.setAmount(newEvent.getAmount());
                try {
                    Field field = event.getClass().getDeclaredField("source");
                    field.setAccessible(true);
                    field.set(event, (Object)newSource);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                event.setAmount(0.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDamage(LivingDamageEvent event) {
        if (ModMain.hasShitInstalled()) {
            WyLivingDamageEvent newEvent = new WyLivingDamageEvent(event.getEntityLiving(), event.getSource(), event.getAmount());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
            if (Float.isNaN(newEvent.getAmount())) {
                return;
            }
            if (!newEvent.isCanceled()) {
                ModDamageSource newSource = new ModDamageSource(newEvent.getSource());
                newSource.ignore();
                event.setAmount(newEvent.getAmount());
                try {
                    Field field = event.getClass().getDeclaredField("source");
                    field.setAccessible(true);
                    field.set(event, (Object)newSource);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                event.setAmount(0.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onWyLivingHurt(WyLivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        DamageSource source = event.getSource();
        Entity sourceEntity = source.func_76346_g();
        Entity directEntity = source.func_76364_f();
        if (!(sourceEntity instanceof LivingEntity) || source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            return;
        }
        LivingEntity attacker = (LivingEntity)sourceEntity;
        LivingEntity target = event.getEntityLiving();
        float amount = event.getAmount();
        List<Effect> preExistingBreakableEffects = target.func_193076_bZ().keySet().stream().filter(effect -> effect instanceof IBreakableEffect).collect(Collectors.toList());
        if (source instanceof ModDamageSource) {
            IAbilityData abilityProps = AbilityDataCapability.get(attacker);
            for (IAbility abl : abilityProps.getEquippedAbilitiesWith(ModAbilityKeys.HIT_TRIGGER)) {
                boolean result;
                HitTriggerComponent comp = abl.getComponent(ModAbilityKeys.HIT_TRIGGER).get();
                if (comp.getResult() == HitTriggerComponent.HitResult.HIT && !(result = comp.onHit(attacker, target, (ModDamageSource)source))) {
                    event.setCanceled(true);
                }
                HitTriggerEvent.Post postTryHitEvent = new HitTriggerEvent.Post(attacker, target, amount, (ModDamageSource)source, abl);
                MinecraftForge.EVENT_BUS.post((Event)postTryHitEvent);
            }
        }
        amount = EffectsEvents.Common.applyBreakableEffectDamage((Entity)attacker, target, amount, preExistingBreakableEffects);
        if ((amount = DamageCalcsEvents.calcExtraDamage(target, source, directEntity, amount)) < 0.0f) {
            event.setCanceled(true);
            return;
        }
        event.setAmount(amount);
    }

    public static FriendlyFireHitResult tryFriendlyFireHit(LivingEntity attacker, LivingEntity target, DamageSource source, float amount) {
        boolean canBypass;
        boolean isBlocked;
        FriendlyFireHitResult returnResult = new FriendlyFireHitResult(source);
        returnResult.damage = amount;
        boolean sameGroup = ModEntityPredicates.getFriendlyFactions(attacker).test((Entity)target);
        if (!CommonConfig.INSTANCE.isFriendlyDamageDisabled()) {
            sameGroup = false;
        }
        HitTriggerEvent preTryHitEvent = null;
        IAbilityData ablProps = AbilityDataCapability.get(attacker);
        ArrayList<IAbility> successfulTryHits = new ArrayList<IAbility>();
        if (FactionEvents.isDirectHit(source) && ablProps != null) {
            ModDamageSource punchSource = null;
            boolean sourceSet = false;
            for (IAbility abl : ablProps.getEquippedAbilitiesWith(ModAbilityKeys.HIT_TRIGGER)) {
                if (punchSource == null) {
                    punchSource = attacker == source.func_76364_f() ? (source instanceof AbilityDamageSource ? (ModDamageSource)source : ModDamageSource.causeAbilityDamage(attacker, abl, "ability")) : new ModIndirectEntityDamageSource("ability", source.func_76364_f(), (Entity)attacker);
                }
                boolean canHit = false;
                HitTriggerComponent comp = abl.getComponent(ModAbilityKeys.HIT_TRIGGER).get();
                HitTriggerComponent.HitResult tryHitResult = comp.tryHit(attacker, target, punchSource);
                if (sameGroup && punchSource.bypassesSameGroupProtection()) {
                    canHit = true;
                } else if (!sameGroup) {
                    canHit = true;
                }
                if (!canHit) continue;
                preTryHitEvent = new HitTriggerEvent.Pre(attacker, target, returnResult.damage, punchSource, abl, tryHitResult);
                if (MinecraftForge.EVENT_BUS.post((Event)preTryHitEvent)) {
                    returnResult.setCancel(true);
                    return returnResult;
                }
                switch (((HitTriggerEvent.Pre)preTryHitEvent).getHitResult()) {
                    case HIT: {
                        returnResult.setSource(preTryHitEvent.getSource());
                        returnResult.setDamage(preTryHitEvent.getBonusDamage());
                        successfulTryHits.add(abl);
                        sourceSet = true;
                        break;
                    }
                    case FAIL: {
                        returnResult.setCancel(true);
                        return returnResult;
                    }
                    case PASS: {
                        if (sourceSet) break;
                        punchSource = null;
                        break;
                    }
                }
            }
        }
        returnResult.damage = FactionEvents.applyDamageBonus(attacker, source, returnResult.damage);
        if (((ISweep)source).isSweeping()) {
            float bonusDamage = Math.max(returnResult.damage - amount, 0.0f);
            float sweepDamage = bonusDamage * EnchantmentHelper.func_191527_a((LivingEntity)attacker);
            returnResult.damage = sweepDamage + amount;
        }
        float damageTaken = AbilitiesEvents.handleDamageTakenComponents(target, returnResult.source, returnResult.damage, DamageTakenComponent.DamageState.ATTACK);
        returnResult.setDamage(damageTaken);
        boolean bl = isBlocked = damageTaken <= 0.0f;
        if (isBlocked) {
            for (IAbility abl : successfulTryHits) {
                HitTriggerComponent comp = abl.getComponent(ModAbilityKeys.HIT_TRIGGER).get();
                comp.resetHitResult();
                HitTriggerBlockedEvent hitTriggerBlockedEvent = new HitTriggerBlockedEvent(abl);
                MinecraftForge.EVENT_BUS.post((Event)hitTriggerBlockedEvent);
            }
        }
        returnResult.setCancel(isBlocked);
        boolean bl2 = canBypass = preTryHitEvent != null && preTryHitEvent.getSource().bypassesSameGroupProtection();
        if (sameGroup && !canBypass) {
            returnResult.setCancel(true);
        }
        return returnResult;
    }

    public static float applyDamageBonus(LivingEntity attacker, DamageSource source, float originalAmount) {
        float amount = originalAmount;
        amount += FactionEvents.applyPunchBonuses(attacker, source);
        amount += FactionEvents.applyHakiBonuses(attacker, source, amount);
        return amount;
    }

    public static float applyPunchBonuses(LivingEntity attacker, DamageSource source) {
        float amount = 0.0f;
        if (source == null) {
            return amount;
        }
        Entity directEntity = source.func_76364_f();
        if (directEntity == null) {
            return amount;
        }
        if (FactionEvents.isDirectHit(source)) {
            ModifiableAttributeInstance punchAttribute;
            if ((AbilityHelper.canUseBrawlerAbilities(attacker) || MorphHelper.getZoanInfo(attacker) != null) && (punchAttribute = attacker.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get())) != null) {
                amount = (float)((double)amount + punchAttribute.func_111126_e());
            }
        } else if (directEntity instanceof AbilityProjectileEntity) {
            Object projSource = ((AbilityProjectileEntity)directEntity).getDamageSource();
            ItemStack projectileWeaponUsed = ItemsHelper.getProjectileUsedWeapon((ProjectileEntity)directEntity);
            if (((ModDamageSource)((Object)projSource)).isFistDamage() && (projectileWeaponUsed == null || projectileWeaponUsed.func_190926_b()) || ((ModDamageSource)((Object)projSource)).isPhysical()) {
                ModifiableAttributeInstance punchAttribute = attacker.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get());
                if (punchAttribute != null) {
                    amount = (float)((double)amount + punchAttribute.func_111126_e());
                }
            } else if (((ModDamageSource)((Object)projSource)).isSlash()) {
                amount += ItemsHelper.getItemDamage(ItemsHelper.getProjectileUsedWeapon((ProjectileEntity)directEntity)) + 1.0f;
            }
        }
        return amount;
    }

    public static float applyHakiBonuses(LivingEntity attacker, DamageSource source, float originalAmount) {
        if (originalAmount <= 0.0f) {
            return 0.0f;
        }
        if (source == null) {
            return 0.0f;
        }
        float amount = 0.0f;
        Entity directEntity = source.func_76364_f();
        boolean hasHardeningActive = HakiHelper.hasHardeningActive(attacker, false, false);
        boolean hasImbuingActive = directEntity instanceof ProjectileEntity && HakiHelper.isProjectileBusoshokuImbued((ProjectileEntity)directEntity) || HakiHelper.hasImbuingActive(attacker, false, false);
        boolean hasAdvancedBusoActive = directEntity instanceof ProjectileEntity && HakiHelper.isProjectileBusoshokuShrouded((ProjectileEntity)directEntity) || HakiHelper.hasAdvancedBusoActive(attacker);
        boolean hasInfusionActive = directEntity instanceof ProjectileEntity && HakiHelper.isProjectileHaoshokuInfused((ProjectileEntity)directEntity) || HakiHelper.hasInfusionActive(attacker);
        boolean hasFullbodyActive = HakiHelper.hasBusoFullbodyActive(attacker);
        boolean hasEmissionActive = HakiHelper.hasBusoEmissionActive(attacker);
        float basicBusoReducer = 1.0f;
        float advancedBusoReducer = 1.0f;
        if (hasFullbodyActive) {
            float f = basicBusoReducer = HakiHelper.getHakiRank(HakiType.BUSOSHOKU, attacker) == HakiHelper.HakiRank.MASTER ? 1.0f : 0.75f;
        }
        if (hasEmissionActive) {
            float f = advancedBusoReducer = HakiHelper.getHakiRank(HakiType.BUSOSHOKU, attacker) == HakiHelper.HakiRank.MASTER ? 1.0f : 0.95f;
        }
        if (FactionEvents.isDirectHit(source)) {
            if (hasHardeningActive && AbilityHelper.canUseBrawlerAbilities(attacker) || hasImbuingActive && ItemsHelper.isSword(attacker.func_184614_ca())) {
                amount = (float)((double)amount + HakiHelper.getBasicBusoshokuHakiDamageBoost(attacker, originalAmount) * (double)basicBusoReducer);
            }
            if (hasAdvancedBusoActive) {
                amount = (float)((double)amount + HakiHelper.getAdvancedBusoshokuHakiDamageBoost(attacker) * (double)advancedBusoReducer);
            }
            if (hasInfusionActive) {
                amount = (float)((double)amount + HaoshokuHakiInfusionAbility.getDamageBoost(attacker, originalAmount));
            }
        } else if (directEntity instanceof ProjectileEntity && !(source instanceof AbilityDamageSource)) {
            if (hasImbuingActive) {
                amount = (float)((double)amount + HakiHelper.getBasicBusoshokuHakiDamageBoost(attacker, originalAmount) * (double)basicBusoReducer);
            }
            if (hasAdvancedBusoActive) {
                amount = (float)((double)amount + HakiHelper.getAdvancedBusoshokuHakiDamageBoost(attacker) * (double)advancedBusoReducer);
                if (HakiHelper.hasBusoInternalDestructionActive(attacker)) {
                    source.func_76348_h();
                }
            }
            if (hasInfusionActive) {
                amount = (float)((double)amount + HaoshokuHakiInfusionAbility.getDamageBoost(attacker, originalAmount));
            }
        } else if (source instanceof AbilityDamageSource) {
            boolean hasInfusionBonus;
            AbilityCore<? extends IAbility> ability = ((AbilityDamageSource)source).getAbilitySource();
            boolean hasHardeningBonus = ability.getSourceHakiNature() == SourceHakiNature.HARDENING && hasHardeningActive;
            boolean hasImbuingBonus = ability.getSourceHakiNature() == SourceHakiNature.IMBUING && hasImbuingActive;
            boolean hasAdvancedBusoBonus = (ability.getSourceHakiNature() == SourceHakiNature.HARDENING || ability.getSourceHakiNature() == SourceHakiNature.IMBUING) && hasAdvancedBusoActive;
            boolean hasSpecialBonus = ability.getSourceHakiNature() == SourceHakiNature.SPECIAL && (HakiHelper.hasHardeningActive(attacker, false, false) || HakiHelper.hasImbuingActive(attacker, false, false) || HakiHelper.hasAdvancedBusoActive(attacker));
            boolean bl = hasInfusionBonus = ability.getSourceHakiNature() != SourceHakiNature.UNKNOWN && hasInfusionActive;
            if (hasSpecialBonus) {
                if (hasHardeningActive || hasImbuingActive) {
                    amount = (float)((double)amount + HakiHelper.getBasicBusoshokuHakiDamageBoost(attacker, originalAmount) * (double)basicBusoReducer);
                }
                if (hasAdvancedBusoActive) {
                    amount = (float)((double)amount + HakiHelper.getAdvancedBusoshokuHakiDamageBoost(attacker) * (double)advancedBusoReducer);
                    if (HakiHelper.hasBusoInternalDestructionActive(attacker)) {
                        ((AbilityDamageSource)source).setPiercing(1.0f);
                    }
                }
            }
            if (hasHardeningBonus || hasImbuingBonus) {
                amount = (float)((double)amount + HakiHelper.getBasicBusoshokuHakiDamageBoost(attacker, originalAmount) * (double)basicBusoReducer);
            }
            if (hasAdvancedBusoBonus) {
                amount = (float)((double)amount + HakiHelper.getAdvancedBusoshokuHakiDamageBoost(attacker) * (double)advancedBusoReducer);
                if (HakiHelper.hasBusoInternalDestructionActive(attacker)) {
                    ((AbilityDamageSource)source).setPiercing(1.0f);
                }
            }
            if (hasInfusionBonus) {
                amount = (float)((double)amount + HaoshokuHakiInfusionAbility.getDamageBoost(attacker, originalAmount));
            }
        }
        return amount;
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileHitEvent event) {
        if (!event.getProjectile().field_70170_p.field_72995_K && CommonConfig.INSTANCE.isFriendlyDamageDisabled() && event.getProjectile().func_234616_v_() instanceof LivingEntity && event.getHit().func_216346_c() == RayTraceResult.Type.ENTITY) {
            LivingEntity attacker = (LivingEntity)event.getProjectile().func_234616_v_();
            EntityRayTraceResult hitResult = (EntityRayTraceResult)event.getHit();
            if (hitResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hitResult.func_216348_a();
                boolean sameGroup = ModEntityPredicates.getFriendlyFactions(attacker).test((Entity)target);
                if (sameGroup) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSetFire(SetOnFireEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && CommonConfig.INSTANCE.isFriendlyDamageDisabled()) {
            LivingEntity attacker = event.getAttacker();
            if (attacker == null) {
                return;
            }
            Entity target = event.getEntity();
            boolean sameGroup = ModEntityPredicates.getFriendlyFactions(attacker).test(target);
            if (sameGroup) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onTargetChange(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof MobEntity && ((MobEntity)event.getEntityLiving()).func_70638_az() != null && CommonConfig.INSTANCE.isFriendlyDamageDisabled()) {
            MobEntity mob = (MobEntity)event.getEntityLiving();
            LivingEntity target = ((MobEntity)event.getEntityLiving()).func_70638_az();
            boolean sameGroup = ModEntityPredicates.getFriendlyFactions(event.getEntityLiving()).test((Entity)target);
            if (sameGroup) {
                mob.func_70624_b(null);
                mob.func_230246_e_(null);
                mob.func_70604_c(null);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinsWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getWorld().field_72995_K && event.getWorld().func_234923_W_() == World.field_234918_g_) {
            IEntityStats props;
            if (!(!((Boolean)CommonConfig.INSTANCE.forceSelection.get()).booleanValue() || (props = EntityStatsCapability.get((LivingEntity)((PlayerEntity)event.getEntity()))).hasRace() && props.hasFaction() && props.hasFightingStyle())) {
                boolean hasRandomizedRace = CommonConfig.INSTANCE.getRaceRandomizer();
                boolean allowMinkRaceSelect = CommonConfig.INSTANCE.getAllowMinkRaceSelect();
                WyNetwork.sendTo(new SOpenCharacterCreatorScreenPacket(hasRandomizedRace, allowMinkRaceSelect), (PlayerEntity)event.getEntity());
            }
            FactionHelper.validateFaction((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onStatsChoose(SetPlayerDetailsEvent event) {
        FactionHelper.validateFaction(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPreHitTrigger(HitTriggerEvent.Pre event) {
        IAbility ability = event.getAbility();
        if (ability instanceof PunchAbility2 && event.getHitResult() == HitTriggerComponent.HitResult.HIT) {
            event.setBonusDamage(event.getBonusDamage() + ((PunchAbility2)ability).getPunchDamage());
        }
    }

    @SubscribeEvent
    public static void onHitTriggerBlocked(HitTriggerBlockedEvent event) {
        IAbility abl = event.getAbility();
        if (abl instanceof PunchAbility2) {
            ((PunchAbility2)abl).increaseUses();
        }
    }

    public static boolean isDirectHit(DamageSource source) {
        Entity sourceEntity = source.func_76346_g();
        Entity directEntity = source.func_76364_f();
        boolean isNormalFist = !(source instanceof AbilityDamageSource) && sourceEntity == directEntity;
        boolean isAbilityFist = source instanceof AbilityDamageSource && ((AbilityDamageSource)source).isFistDamage();
        boolean isNotExplosion = !source.func_94541_c() && (!(source instanceof AbilityDamageSource) || ((AbilityDamageSource)source).getElement() != SourceElement.EXPLOSION && ((AbilityDamageSource)source).getElement() != SourceElement.SHOCKWAVE);
        boolean isNotIgnored = !(source instanceof ModDamageSource) || !((ModDamageSource)source).isIgnored();
        boolean isIndirect = source instanceof AbilityDamageSource && ((AbilityDamageSource)source).hasType(SourceType.INDIRECT);
        return (isNormalFist || isAbilityFist) && isNotExplosion && isNotIgnored && !isIndirect;
    }

    private static boolean isDamageSourceBlockedByShield(DamageSource source, LivingEntity target) {
        AbstractArrowEntity abstractarrowentity;
        Entity sourceEntity = source.func_76346_g();
        Entity entity = source.func_76364_f();
        boolean isPiercing = false;
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            isPiercing = true;
        }
        boolean isPhysical = source instanceof ModDamageSource && ((ModDamageSource)source).isPhysical() && source.func_76352_a() && !((ModDamageSource)source).hasType(SourceType.INDIRECT);
        boolean isDirect = FactionEvents.isDirectHit(source);
        if (!source.func_76363_c() && target.func_184585_cz() && !isPiercing && (isPhysical || isDirect)) {
            Vector3d sourcePos = source.func_188404_v();
            if (sourcePos == null && sourceEntity != null) {
                sourcePos = sourceEntity.func_213303_ch();
            }
            if (sourcePos != null) {
                Vector3d vector3d = target.func_70676_i(1.0f);
                Vector3d vector3d1 = sourcePos.func_72444_a(target.func_213303_ch()).func_72432_b();
                vector3d1 = new Vector3d(vector3d1.field_72450_a, 0.0, vector3d1.field_72449_c);
                if (vector3d1.func_72430_b(vector3d) < 0.0) {
                    return true;
                }
            }
        }
        return false;
    }

    private static class FriendlyFireHitResult {
        private boolean cancel = false;
        private DamageSource source;
        private float damage = 0.0f;

        public FriendlyFireHitResult(DamageSource defaultSource) {
            this.source = defaultSource;
        }

        public void setCancel(boolean flag) {
            this.cancel = flag;
        }

        public void setSource(DamageSource source) {
            this.source = source;
        }

        public void setDamage(float damage) {
            this.damage = damage;
        }
    }
}

