/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.api.events.stats.LoyaltyEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class LoyaltyEvents {
    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        boolean hasLoyalty;
        if (!(event.getEntityLiving() instanceof PlayerEntity) || event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        boolean bl = hasLoyalty = props.isMarine() || props.isRevolutionary() || props.isBountyHunter();
        if (!hasLoyalty || props.getLoyalty() >= 100.0) {
            return;
        }
        if (props.getDoriki() < 4000.0 && props.getLoyalty() > 15.0) {
            return;
        }
        if (player.field_70170_p.func_82737_E() % 24000L == 0L) {
            int loyaltyGain = MathHelper.func_76128_c((double)(1.0 * CommonConfig.INSTANCE.getLoyaltyMultiplier()));
            props.alterLoyalty(loyaltyGain, StatChangeSource.NATURAL);
        }
    }

    @SubscribeEvent
    public static void checkForAbilityGain(LoyaltyEvent event) {
        PlayerEntity player = event.getPlayer();
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        boolean updates = false;
        if (props.isMarine()) {
            for (AbilityCore core : ModAbilities.MARINE_ABILITIES) {
                updates |= AbilityHelper.checkAndUnlockAbility((LivingEntity)player, core);
            }
        } else if (props.isRevolutionary()) {
            // empty if block
        }
        if (updates) {
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), player);
        }
    }

    @SubscribeEvent
    public static void onStatsChoose(SetPlayerDetailsEvent event) {
        event.getEntityStats().setLoyalty(0.0);
    }

    private static void gainRevolutionaryAbility(PlayerEntity player, FactionHelper.RevolutionaryRank rank, AbilityCore ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        if (props.hasRevolutionaryRank(rank) && !abilityProps.hasUnlockedAbility(ability) && !AbilityHelper.verifyIfAbilityIsBanned(ability)) {
            abilityProps.addUnlockedAbility(ability, AbilityUnlock.PROGRESSION);
            player.func_145747_a((ITextComponent)new StringTextComponent("Obtained " + ability.getUnlocalizedName()), Util.field_240973_b_);
        }
        if ((!props.hasRevolutionaryRank(rank) || AbilityHelper.verifyIfAbilityIsBanned(ability)) && abilityProps.hasUnlockedAbility(ability)) {
            abilityProps.removeUnlockedAbility(ability);
        }
        WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps), player);
    }

    private static void gainMarineAbility(PlayerEntity player, FactionHelper.MarineRank rank, AbilityCore ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        if (props.hasMarineRank(rank) && !abilityProps.hasUnlockedAbility(ability) && !AbilityHelper.verifyIfAbilityIsBanned(ability)) {
            abilityProps.addUnlockedAbility(ability, AbilityUnlock.PROGRESSION);
            player.func_145747_a((ITextComponent)new StringTextComponent("Obtained " + ability.getUnlocalizedName()), Util.field_240973_b_);
        }
        if ((!props.hasMarineRank(rank) || AbilityHelper.verifyIfAbilityIsBanned(ability)) && abilityProps.hasUnlockedAbility(ability)) {
            abilityProps.removeUnlockedAbility(ability);
        }
        WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps), player);
    }
}

