/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import com.google.common.base.Strings;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.renderers.morphs.ZoanMorphRenderer2;

public class MorphEvents {

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class Common {
        @SubscribeEvent
        public static void onZoanSizeChange(EntityEvent.Size event) {
            if (!(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)event.getEntity();
            if (living.func_70047_e() <= 0.0f) {
                return;
            }
            IDevilFruit props = DevilFruitCapability.get(living);
            Pose pose = living.func_213283_Z();
            EntitySize size = living.func_213305_a(pose);
            float eyeHeight = living.getEyeHeightAccess(pose, size);
            MorphInfo info = null;
            if (!Strings.isNullOrEmpty((String)props.getZoanPoint())) {
                info = MorphHelper.getZoanInfo(living);
                if (info == null) {
                    return;
                }
                if (info.getEyeHeight() <= 0.0) {
                    return;
                }
                eyeHeight = (float)(1.62 * (info.getEyeHeight() / 1.75));
                if (eyeHeight < 0.22f) {
                    eyeHeight = 0.22f;
                }
            }
            if (info != null && living.func_213453_ef()) {
                eyeHeight -= 0.3f;
                eyeHeight = (float)Math.max(0.3, (double)eyeHeight);
            }
            event.setNewEyeHeight(eyeHeight);
        }

        @SubscribeEvent
        public static void onZoanMounts(EntityMountEvent event) {
            PlayerEntity player;
            MorphInfo info;
            if (event.getEntityBeingMounted() == null) {
                return;
            }
            if (event.getEntityMounting() instanceof PlayerEntity && (info = MorphHelper.getZoanInfo((LivingEntity)(player = (PlayerEntity)event.getEntityMounting()))) != null && !info.canMount()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_MOUNT_ZOAN), Util.field_240973_b_);
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void onEntityRendered(RenderLivingEvent.Pre event) {
            IDevilFruit props = DevilFruitCapability.get(event.getEntity());
            if (!Strings.isNullOrEmpty((String)props.getZoanPoint())) {
                try {
                    MorphInfo info = MorphHelper.getZoanInfo(event.getEntity());
                    if (info != null) {
                        event.setCanceled(true);
                        EntityRenderer renderer = info.getRendererFactory(event.getEntity()).createRenderFor(Minecraft.func_71410_x().func_175598_ae());
                        if (renderer instanceof ZoanMorphRenderer2) {
                            ((ZoanMorphRenderer2)renderer).setOriginalRenderer(event.getRenderer());
                        }
                        renderer.func_225623_a_((Entity)event.getEntity(), event.getEntity().field_70177_z, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
                    }
                }
                catch (Exception e) {
                    event.setCanceled(false);
                }
            }
        }

        @SubscribeEvent
        public static void onHandRendering(RenderHandEvent event) {
            boolean isBlackLeg;
            if (event.getHand() != Hand.MAIN_HAND) {
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
            if (abilityProps == null) {
                return;
            }
            boolean renderHand = false;
            boolean hasEmptyHand = player.func_184614_ca().func_190926_b();
            MorphInfo info = MorphHelper.getZoanInfo((LivingEntity)player);
            boolean isOverlay = false;
            Optional<Object> overlay = Optional.empty();
            for (IAbility ability : abilityProps.getEquippedAbilities()) {
                Optional<SkinOverlayComponent> comp = ability.getComponent(ModAbilityKeys.SKIN_OVERLAY);
                if (comp.isPresent() && (overlay = comp.get().getShownOverlay(AbilityOverlay.OverlayPart.values())).isPresent()) {
                    isOverlay = hasEmptyHand;
                    break;
                }
                if (info == null) continue;
                renderHand = true;
            }
            boolean isZoan = hasEmptyHand && renderHand;
            boolean bl = isBlackLeg = props.isBlackLeg() && hasEmptyHand && (props.isInCombatMode() || ClientConfig.INSTANCE.isBlackLegAlwaysUp());
            if (isZoan || isOverlay || isBlackLeg) {
                event.setCanceled(true);
                MorphHelper.renderLimbFirstPerson(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getEquipProgress(), event.getSwingProgress(), player.func_184591_cq(), overlay, info);
            }
        }
    }
}

