/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.LootTable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.NotoriousEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.DoppelmanEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.MirageCloneEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.NightmareSoldierEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.WaxCloneEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class StatsGainEvents {
    private static final double HEALTH_STAT_MAX = 750.0;
    private static final double ATTACK_STAT_MAX = 40.0;

    public static void setSpawnStats(MobEntity entity) {
        ModifiableAttributeInstance attrAtk = entity.func_233645_dx_().func_233779_a_(Attributes.field_233823_f_);
        ModifiableAttributeInstance attrHP = entity.func_233645_dx_().func_233779_a_(Attributes.field_233818_a_);
        if (attrAtk == null || attrHP == null) {
            return;
        }
        boolean isHardDifficulty = entity.field_70170_p.func_175659_aa().func_151525_a() > Difficulty.NORMAL.func_151525_a();
        double attackValue = attrAtk.func_111126_e();
        double healthValue = attrHP.func_111126_e();
        IEntityStats statProps = EntityStatsCapability.get((LivingEntity)entity);
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
        if (statProps != null && statProps.getDoriki() <= 0.0) {
            long dummyBelly;
            int randomExtraBelly;
            double dorikiLimit = 10000.0;
            double dummyDoriki = healthValue / 750.0 * 0.3 + attackValue / 40.0 * 0.7 * (dorikiLimit * 0.8);
            int randomExtraDoriki = (int)Math.round(dummyDoriki / 10.0);
            if (randomExtraDoriki > 0) {
                dummyDoriki += (double)entity.func_70681_au().nextInt(randomExtraDoriki);
            }
            if (isHardDifficulty) {
                dummyDoriki += WyHelper.randomWithRange(250, 750);
            }
            if ((randomExtraBelly = Math.round((float)(dummyBelly = (long)((dummyDoriki = MathHelper.func_151237_a((double)dummyDoriki, (double)50.0, (double)dorikiLimit)) / 100.0)) / 2.0f)) > 0) {
                dummyBelly += (long)entity.func_70681_au().nextInt(randomExtraBelly);
            }
            dummyBelly = WyHelper.clamp(dummyBelly, 1L, 999999999L);
            statProps.setDoriki(dummyDoriki);
            statProps.setBelly(dummyBelly);
        }
        if (hakiProps != null) {
            double hakiLimit = 100.0;
            if (hakiProps.getKenbunshokuHakiExp() <= 0.0f) {
                double dummyObs = healthValue / 750.0 * 0.6 + attackValue / 40.0 * 0.4 * (hakiLimit * 0.8);
                int randomExtraObs = (int)Math.round(dummyObs / 10.0);
                if (randomExtraObs > 0) {
                    dummyObs += (double)entity.func_70681_au().nextInt(randomExtraObs);
                }
                if (isHardDifficulty) {
                    dummyObs += WyHelper.randomWithRange(5, 10);
                }
                dummyObs = MathHelper.func_151237_a((double)dummyObs, (double)2.5, (double)hakiLimit);
                hakiProps.setKenbunshokuHakiExp((float)dummyObs);
            }
            if (hakiProps.getBusoshokuHakiExp() <= 0.0f) {
                double dummyBuso = healthValue / 750.0 * 0.4 + attackValue / 40.0 * 0.6 * (hakiLimit * 0.8);
                int randomExtraBuso = (int)Math.round(dummyBuso / 10.0);
                if (randomExtraBuso > 0) {
                    dummyBuso += (double)entity.func_70681_au().nextInt(randomExtraBuso);
                }
                if (isHardDifficulty) {
                    dummyBuso += WyHelper.randomWithRange(5, 10);
                }
                dummyBuso = MathHelper.func_151237_a((double)dummyBuso, (double)2.5, (double)hakiLimit);
                hakiProps.setBusoshokuHakiExp((float)dummyBuso);
            }
        }
    }

    public static void removeIssuedBounty(LivingEntity target) {
        if (target.field_70170_p.field_72995_K) {
            return;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get();
        if (worldData.hasIssuedBounty(target)) {
            worldData.removeBounty(target.func_110124_au());
        }
    }

    public static void giveStats(LivingEntity target, DamageSource source) {
        if (target.field_70170_p.field_72995_K) {
            return;
        }
        if (!CommonConfig.INSTANCE.isMobRewardsEnabled()) {
            return;
        }
        if (WyHelper.isInChallengeDimension(target.field_70170_p)) {
            return;
        }
        PlayerEntity player = null;
        if (source.func_76346_g() instanceof PlayerEntity) {
            player = (PlayerEntity)source.func_76346_g();
        } else if (source instanceof AbilityDamageSource && source.func_76364_f() instanceof PlayerEntity) {
            player = (PlayerEntity)source.func_76364_f();
        }
        if (player == null) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        long plusBelly = 0L;
        long plusBounty = 0L;
        double plusDoriki = 0.0;
        StatChangeSource statSource = StatChangeSource.KILL_NPC;
        IEntityStats targetprops = EntityStatsCapability.get(target);
        if ((props.isMarine() || targetprops.isBountyHunter()) && (targetprops.isMarine() || targetprops.isBountyHunter())) {
            player.func_146105_b(ModI18n.INFO_LOYALTY_DROPPED, true);
            StatChangeSource loyaltySource = target instanceof PlayerEntity ? StatChangeSource.KILL_PLAYER : StatChangeSource.KILL_NPC;
            props.alterLoyalty(-0.5, loyaltySource);
        }
        if (target instanceof PlayerEntity) {
            double dorikiLost = targetprops.getDoriki() - WyHelper.percentage(CommonConfig.INSTANCE.getDorikiKeepPercentage(), targetprops.getDoriki());
            plusDoriki = dorikiLost / 4.0;
            double bountyLost = (double)targetprops.getBounty() - WyHelper.percentage(CommonConfig.INSTANCE.getBountyKeepPercentage(), targetprops.getBounty());
            plusBounty = (long)(bountyLost / 2.0);
            double bellyLost = (double)targetprops.getBelly() - WyHelper.percentage(CommonConfig.INSTANCE.getBellyKeepPercentage(), targetprops.getBelly());
            plusBelly = (long)bellyLost;
            statSource = StatChangeSource.KILL_PLAYER;
        } else {
            if (target instanceof DoppelmanEntity || target instanceof NightmareSoldierEntity || target instanceof MirageCloneEntity || target instanceof BlackKnightEntity || target instanceof WaxCloneEntity) {
                return;
            }
            if (props.isMarine() && targetprops.isMarine()) {
                return;
            }
            if (props.isRevolutionary() && targetprops.isRevolutionary()) {
                return;
            }
            LootTable loottable = target.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(target.func_213346_cF());
            if (loottable.getPool("mineminenomi:stats") != null) {
                return;
            }
            double targetDoriki = targetprops.getDoriki();
            if (targetDoriki > 0.0) {
                plusDoriki = targetDoriki / 100.0;
                if (props.getDoriki() > targetDoriki) {
                    plusDoriki = targetDoriki / 10000.0;
                }
                if (plusDoriki < 1.0 && CommonConfig.INSTANCE.isMinimumDorikiPerKillEnabled()) {
                    plusDoriki = 1.0;
                }
                plusBounty = (long)targetDoriki / 20L;
                plusBelly = targetprops.getBelly();
            }
            if (target instanceof VillagerEntity) {
                plusBounty = 250L;
            } else if (target instanceof NotoriousEntity && plusDoriki < 100.0) {
                plusDoriki = 100.0;
            }
            plusDoriki *= CommonConfig.INSTANCE.getDorikiRewardMultiplier();
            plusBounty = (long)((double)plusBounty * CommonConfig.INSTANCE.getBountyRewardMultiplier());
            plusBelly = (long)((double)plusBelly * CommonConfig.INSTANCE.getBellyRewardMultiplier());
            statSource = StatChangeSource.KILL_NPC;
        }
        WyDebug.debug("\nDoriki: " + plusDoriki + "\nBelly: " + plusBelly + "\nBounty: " + plusBounty);
        if (plusDoriki > 0.0) {
            props.alterDoriki(plusDoriki, statSource);
        }
        if (BountyHelper.canGainBounty((LivingEntity)player) && plusBounty > 0L) {
            props.alterBounty(plusBounty, statSource);
        }
        if (plusBelly > 0L) {
            props.alterBelly(plusBelly, statSource);
        }
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
    }
}

