/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.items;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.SoulboundMark;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.SoulboundItemHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModItems;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class SoulboundItemsEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getWorld().field_72995_K) {
            UUID uuid = event.getEntity().func_110124_au();
            ExtendedWorldData worldData = ExtendedWorldData.get();
            if (worldData.isOnDeathList(uuid)) {
                AbilityHelper.resetSpawnInvulnerability((ServerPlayerEntity)event.getEntity());
                if (event.getEntity().func_70097_a(ModDamageSource.SOULBOUND_DAMAGE, Float.MAX_VALUE)) {
                    worldData.removeMark(uuid);
                }
            } else if (worldData.isOnRestoreList(uuid, SoulboundMark.RESTORE_HEART)) {
                EntityStatsCapability.get((LivingEntity)event.getEntity()).setHeart(true);
                worldData.removeMark(uuid);
            } else if (worldData.isOnRestoreList(uuid, SoulboundMark.RESTORE_DOLL)) {
                EntityStatsCapability.get((LivingEntity)event.getEntity()).setStrawDoll(true);
                worldData.removeMark(uuid);
            }
        }
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        ItemEntity itemEntity = event.getEntityItem();
        ItemStack stack = itemEntity.func_92059_d();
        if (stack.func_77973_b() == ModItems.HEART.get()) {
            Pair<UUID, LivingEntity> owner = SoulboundItemHelper.getOwner(itemEntity.field_70170_p, stack);
            if (owner.getValue() != null) {
                EntityStatsCapability.get((LivingEntity)owner.getValue()).setHeart(true);
            } else {
                ExtendedWorldData.get().markRestore((UUID)owner.getKey(), SoulboundMark.RESTORE_HEART);
            }
        } else if (stack.func_77973_b() == ModItems.STRAW_DOLL.get()) {
            Pair<UUID, LivingEntity> owner = SoulboundItemHelper.getOwner(itemEntity.field_70170_p, stack);
            if (owner.getValue() != null) {
                EntityStatsCapability.get((LivingEntity)owner.getValue()).setStrawDoll(true);
            } else {
                ExtendedWorldData.get().markRestore((UUID)owner.getKey(), SoulboundMark.RESTORE_DOLL);
            }
        }
    }
}

