/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.world;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModBiomes;

public class BiomeHandler {

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private static float rainThreshold = 0.0f;
        private static long firstTick = 0L;

        public static float getDrumSnowLevel(Minecraft minecraft, float currentRainLevel, ResourceLocation biomeId) {
            ClientPlayerEntity player = minecraft.field_71439_g;
            IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
            if (biomeId.equals((Object)ModBiomes.DRUM.getId())) {
                if (props.hasDevilFruit(ModAbilities.MERA_MERA_NO_MI)) {
                    return Client.decreaseSnow(player, currentRainLevel, 0.0f);
                }
                return Client.increaseSnow(player, currentRainLevel, 1.0f);
            }
            return Client.decreaseSnow(player, currentRainLevel, currentRainLevel);
        }

        private static float increaseSnow(ClientPlayerEntity player, float currentRainLevel, float def) {
            if (rainThreshold < 0.95f) {
                if (firstTick == 0L) {
                    firstTick = player.field_70173_aa;
                }
                rainThreshold = EasingFunctionHelper.easeInOutQuad(Float.valueOf((float)((long)player.field_70173_aa - firstTick) % 100.0f / 100.0f));
                float newRainLevel = MathHelper.func_76131_a((float)(currentRainLevel + rainThreshold * 0.7f), (float)0.0f, (float)1.0f);
                return newRainLevel;
            }
            firstTick = 0L;
            return def;
        }

        private static float decreaseSnow(ClientPlayerEntity player, float currentRainLevel, float def) {
            if ((double)rainThreshold > 0.0) {
                if (firstTick == 0L) {
                    firstTick = player.field_70173_aa;
                }
                float level = EasingFunctionHelper.easeInOutQuad(Float.valueOf((float)((long)player.field_70173_aa - firstTick) % 100.0f / 100.0f));
                rainThreshold = MathHelper.func_76131_a((float)(rainThreshold + (currentRainLevel - level)), (float)0.0f, (float)1.0f);
                return rainThreshold;
            }
            firstTick = 0L;
            return def;
        }
    }
}

