/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import com.google.common.base.Predicates;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.WantedPosterPackageEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.ITamableEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.KungFuDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.YagaraBullEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ModEntityPredicates {
    public static final Predicate<Entity> ENTITY_EXISTS = entity -> entity != null;
    public static final Predicate<Entity> IS_ALIVE_AND_SURVIVAL = ENTITY_EXISTS.and(EntityPredicates.field_188444_d).and(EntityPredicates.field_94557_a);
    public static final Predicate<Entity> IS_ENTITY_HARMLESS = target -> {
        EntityClassification classification = target.func_200600_R().func_220339_d();
        if (classification.equals((Object)EntityClassification.WATER_AMBIENT) || classification.equals((Object)EntityClassification.AMBIENT)) {
            return true;
        }
        if (target instanceof AnimalEntity || target instanceof AmbientEntity || target instanceof AbstractFishEntity || target instanceof GolemEntity) {
            return true;
        }
        return target instanceof SquidEntity || target instanceof WantedPosterPackageEntity;
    };
    public static final Predicate<Entity> IS_INVISIBLE = target -> target.func_82150_aj();
    public static final Predicate<Entity> TARGET_HAS_ISSUED_BOUNTY = targetEntity -> {
        if (!(targetEntity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity target = (LivingEntity)targetEntity;
        ExtendedWorldData worldData = ExtendedWorldData.get();
        IEntityStats targetProps = EntityStatsCapability.get(target);
        if (targetProps.isPirate() || targetProps.isRevolutionary() || targetProps.isBandit()) {
            if (StructuresHelper.isInsideModStructure((ServerWorld)target.field_70170_p, target.func_233580_cy_(), StructuresHelper.StructureFaction.MARINE)) {
                return true;
            }
            if (target instanceof PlayerEntity && target.func_130014_f_().func_175659_aa().func_151525_a() <= Difficulty.NORMAL.func_151525_a() && !worldData.hasIssuedBounty(target)) {
                return false;
            }
        }
        return true;
    };

    public static Predicate<Entity> canBeSeenBy(LivingEntity entity) {
        return IS_ALIVE_AND_SURVIVAL.and(target -> entity.func_70685_l(target));
    }

    public static Predicate<Entity> canSee(LivingEntity entity) {
        return IS_ALIVE_AND_SURVIVAL.and(target -> target instanceof LivingEntity ? ((LivingEntity)target).func_70685_l((Entity)entity) : false);
    }

    public static Predicate<Entity> hasTargetWithinDistance(LivingEntity entity, float distance) {
        return ModEntityPredicates.canSee(entity).and(EntityPredicates.func_188443_a((double)entity.func_213303_ch().field_72450_a, (double)entity.func_213303_ch().field_72448_b, (double)entity.func_213303_ch().field_72449_c, (double)distance));
    }

    public static Predicate<Entity> canBeTamed() {
        return target -> target instanceof TameableEntity || target instanceof AbstractHorseEntity || target instanceof OcelotEntity || target instanceof KungFuDugongEntity || target instanceof YagaraBullEntity || target instanceof ICommandReceiver;
    }

    public static Predicate<Entity> isTamedBy(@Nullable LivingEntity tamer) {
        return target -> {
            if (tamer == null) {
                return false;
            }
            if (!ModEntityPredicates.canBeTamed().test((Entity)target)) {
                return false;
            }
            if (target instanceof TameableEntity) {
                return ((TameableEntity)target).func_70902_q() != null && ((TameableEntity)target).func_70902_q().equals((Object)tamer);
            }
            if (target instanceof AbstractHorseEntity) {
                return ((AbstractHorseEntity)target).func_184780_dh() != null && ((AbstractHorseEntity)target).func_184780_dh().equals(tamer.func_110124_au());
            }
            if (target instanceof OcelotEntity) {
                Method method = ObfuscationReflectionHelper.findMethod(OcelotEntity.class, (String)"func_213530_dX", (Class[])new Class[0]);
                try {
                    method.setAccessible(true);
                    boolean isTrusting = (Boolean)method.invoke(target, new Object[0]);
                    return isTrusting;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (target instanceof YagaraBullEntity) {
                return ((YagaraBullEntity)target).func_70902_q() != null && ((YagaraBullEntity)target).func_70902_q().equals((Object)tamer);
            }
            if (target instanceof KungFuDugongEntity) {
                return ((KungFuDugongEntity)target).func_70902_q() != null && ((KungFuDugongEntity)target).func_70902_q().equals((Object)tamer);
            }
            if (target instanceof ITamableEntity) {
                ITamableEntity tamableEntity = (ITamableEntity)target;
                return tamableEntity.getOwnerIfAlive() != null && tamableEntity.getOwner().equals((Object)tamer);
            }
            return target instanceof ICommandReceiver && ((ICommandReceiver)target).canReceiveCommandFrom(tamer);
        };
    }

    public static Predicate<Entity> getEnemyFactions(LivingEntity entity) {
        if (entity == null) {
            return Predicates.alwaysTrue();
        }
        return targetEntity -> {
            boolean isCivilian;
            boolean isSpectating;
            if (targetEntity == null) {
                return false;
            }
            if (!(targetEntity instanceof LivingEntity)) {
                return false;
            }
            if (entity == targetEntity) {
                return false;
            }
            LivingEntity target = (LivingEntity)targetEntity;
            if (entity.field_70170_p instanceof ServerWorld && WyHelper.isInChallengeDimension(entity.field_70170_p)) {
                InProgressChallenge challenge = ChallengesWorldData.get().getInProgressChallengeFor((ServerWorld)entity.field_70170_p);
                if (challenge != null) {
                    ITamableEntity tameable;
                    if (entity instanceof ITamableEntity && (tameable = (ITamableEntity)entity).getOwner() != null) {
                        if (challenge.getGroup().contains(tameable.getOwner()) && !challenge.getGroup().contains(target)) {
                            return true;
                        }
                        if (challenge.getEnemies().contains(tameable.getOwner()) && !challenge.getEnemies().contains(target)) {
                            return true;
                        }
                    }
                    if (challenge.getGroup().contains(entity) && !challenge.getGroup().contains(target)) {
                        return true;
                    }
                    if (challenge.getEnemies().contains(entity) && !challenge.getEnemies().contains(target)) {
                        return true;
                    }
                }
                return false;
            }
            if (target.func_184207_aI() && target.func_184179_bs() != null && ModEntityPredicates.getFriendlyFactions(entity).test(target.func_184179_bs())) {
                return false;
            }
            boolean bl = isSpectating = !EntityPredicates.field_180132_d.test(target);
            if (isSpectating) {
                return false;
            }
            IEntityStats livingProps = EntityStatsCapability.get(entity);
            IEntityStats targetProps = EntityStatsCapability.get(target);
            if (livingProps.isRogue() || targetProps.isRogue()) {
                return true;
            }
            if (ModEntityPredicates.isTamedBy(entity).test((Entity)target)) {
                return false;
            }
            if (ModEntityPredicates.canBeTamed().test((Entity)entity) && ModEntityPredicates.isTamedBy(MobsHelper.getTamer(entity)).test((Entity)target)) {
                return false;
            }
            ExtendedWorldData worldData = ExtendedWorldData.get();
            if (livingProps.isPirate() && targetProps.isPirate()) {
                if (entity instanceof AbstractPirateEntity && target instanceof AbstractPirateEntity) {
                    return false;
                }
                if (entity instanceof OPEntity && target instanceof OPEntity && ((OPEntity)entity).getCrew().equals(((OPEntity)target).getCrew())) {
                    return false;
                }
                if (worldData != null) {
                    Crew livingCrew = worldData.getCrewWithMember(entity.func_110124_au());
                    if (livingCrew == null) {
                        return true;
                    }
                    Crew targetCrew = worldData.getCrewWithMember(target.func_110124_au());
                    if (targetCrew == null) {
                        return true;
                    }
                    return !livingCrew.equals(targetCrew);
                }
            }
            boolean bl2 = isCivilian = target instanceof AbstractVillagerEntity || targetProps.isCivilian();
            if ((livingProps.isMarine() || livingProps.isBountyHunter()) && (targetProps.isMarine() || targetProps.isBountyHunter() || isCivilian)) {
                return false;
            }
            if (livingProps.isRevolutionary() && (targetProps.isRevolutionary() || isCivilian)) {
                return false;
            }
            return !livingProps.isBandit() || !targetProps.isBandit();
        };
    }

    public static Predicate<Entity> getFriendlyFactions(LivingEntity entity) {
        return ModEntityPredicates.getEnemyFactions(entity).negate();
    }
}

