/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.integrations.curios;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.integrations.curios.SimpleCurioItem;
import xyz.pixelatedw.mineminenomi.integrations.curios.renderers.ArmorCurioRenderer;
import xyz.pixelatedw.mineminenomi.integrations.curios.renderers.ICurioRenderer;
import xyz.pixelatedw.mineminenomi.integrations.curios.renderers.ItemCurioRenderer;

public class CuriosIntegration {
    private static final String FACE_SLOT_ID = "face";
    private static final ResourceLocation FACE_SLOT_ICON = new ResourceLocation("mineminenomi", "curios/face");
    private static final SlotTypeMessage.Builder FACE_SLOT = new SlotTypeMessage.Builder("face").priority(45).icon(FACE_SLOT_ICON);
    private static final Map<Item, Function<ItemStack, ICurio>> CURIO_ITEMS = new HashMap<Item, Function<ItemStack, ICurio>>();
    private static final Map<Item, ICurioRenderer> CURIO_RENDERERS = new HashMap<Item, ICurioRenderer>();

    public static final void setup(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> ((SlotTypeMessage.Builder)FACE_SLOT).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
    }

    public static final void setupIcons(TextureStitchEvent.Pre event) {
        event.addSprite(FACE_SLOT_ICON);
    }

    public static ICurioRenderer getRenderer(Item item) {
        return CURIO_RENDERERS.get(item);
    }

    public static void setupCurioCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        Item item = stack.func_77973_b();
        if (CURIO_ITEMS.containsKey(item)) {
            final LazyOptional curioItem = LazyOptional.of(() -> CURIO_ITEMS.get(item).apply(stack));
            event.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, curioItem);
                }
            });
        }
    }

    public static void registerCurioItems() {
        CURIO_ITEMS.put((Item)ModArmors.CELESTIAL_DRAGON_BUBBLE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.BICORNE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.CHOPPERS_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.KILLER_MASK.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.LAW_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.TRICORNE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.SABO_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.MIHAWK_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.FLEET_ADMIRAL_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.PLUME_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.WIDE_BRIM_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.STRAW_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.ACES_HAT.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.FRANKY_GLASSES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.CABAJI_SCARF.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.BIG_RED_NOSE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.KURO_GLASSES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.MR3_GLASSES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.MR5_GLASSES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.SNIPER_GOGGLES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.MH5_GAS_MASK.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.KIZARU_GLASSES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.DOFFY_GLASSES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.HEART_GLASSES.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModItems.CIGAR.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModItems.CIGARETTE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModItems.SMOKING_PIPE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModItems.THREE_CIGARS.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.FLUFFY_CAPE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.MARINE_CAPTAIN_CAPE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.PIRATE_CAPTAIN_CAPE.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.COLA_BACKPACK.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.MEDIC_BAG.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModArmors.TOMOE_DRUMS.get(), SimpleCurioItem::new);
        CURIO_ITEMS.put((Item)ModItems.COLOR_PALETTE.get(), SimpleCurioItem::new);
    }

    public static void registerCurioRenderers() {
        CURIO_RENDERERS.put((Item)ModArmors.CELESTIAL_DRAGON_BUBBLE.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.BICORNE.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.CHOPPERS_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.KILLER_MASK.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.LAW_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.TRICORNE.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.SABO_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.MIHAWK_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.FLEET_ADMIRAL_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.PLUME_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.WIDE_BRIM_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.STRAW_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.ACES_HAT.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.FRANKY_GLASSES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.CABAJI_SCARF.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.BIG_RED_NOSE.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.KURO_GLASSES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.MR3_GLASSES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.MR5_GLASSES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.SNIPER_GOGGLES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.MH5_GAS_MASK.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.KIZARU_GLASSES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.DOFFY_GLASSES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.HEART_GLASSES.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModItems.CIGAR.get(), new ItemCurioRenderer());
        CURIO_RENDERERS.put((Item)ModItems.CIGARETTE.get(), new ItemCurioRenderer());
        CURIO_RENDERERS.put((Item)ModItems.SMOKING_PIPE.get(), new ItemCurioRenderer());
        CURIO_RENDERERS.put((Item)ModItems.THREE_CIGARS.get(), new ItemCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.FLUFFY_CAPE.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.MARINE_CAPTAIN_CAPE.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.PIRATE_CAPTAIN_CAPE.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.COLA_BACKPACK.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.MEDIC_BAG.get(), new ArmorCurioRenderer());
        CURIO_RENDERERS.put((Item)ModArmors.TOMOE_DRUMS.get(), new ArmorCurioRenderer());
    }
}

