/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.integrations.curios;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProgressionEvents;
import xyz.pixelatedw.mineminenomi.integrations.curios.CuriosIntegration;
import xyz.pixelatedw.mineminenomi.integrations.curios.renderers.ICurioRenderer;

public class SimpleCurioItem
implements ICurio {
    private final ItemStack stack;

    public SimpleCurioItem(ItemStack stack) {
        this.stack = stack;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ICurioRenderer renderer = CuriosIntegration.getRenderer(this.stack.func_77973_b());
        if (renderer != null) {
            renderer.render(identifier, index, matrixStack, renderTypeBuffer, light, livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, this.stack);
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity) {
        if (livingEntity instanceof PlayerEntity) {
            this.stack.func_77973_b().onArmorTick(this.stack, livingEntity.field_70170_p, (PlayerEntity)livingEntity);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack) {
        AbilityProgressionEvents.updateEquipmentProgression(slotContext.getWearer(), this.stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        AbilityProgressionEvents.updateEquipmentProgression(slotContext.getWearer(), this.stack);
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
        return true;
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }
}

