/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.integrations.curios.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.curios.api.type.capability.ICurio;
import xyz.pixelatedw.mineminenomi.integrations.curios.renderers.ICurioRenderer;

public class ArmorCurioRenderer
implements ICurioRenderer {
    @Override
    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)stack);
        BipedModel model = stack.func_77973_b().getArmorModel(entity, stack, slot, null);
        model.func_225597_a_(entity, limbSwing, limbSwingAmount, partialTicks, netHeadYaw, headPitch);
        model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.setPartVisibility((BipedModel<LivingEntity>)model, slot);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
        if (stack.func_77973_b() instanceof IDyeableArmorItem) {
            int color = ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            this.renderLayer(stack, (BipedModel<LivingEntity>)model, matrixStack, buffer, entity, red, green, blue, light, null);
            this.renderLayer(stack, (BipedModel<LivingEntity>)model, matrixStack, buffer, entity, 1.0f, 1.0f, 1.0f, light, "overlay");
        } else {
            this.renderLayer(stack, (BipedModel<LivingEntity>)model, matrixStack, buffer, entity, 1.0f, 1.0f, 1.0f, light, null);
        }
    }

    private void renderLayer(ItemStack stack, BipedModel<LivingEntity> model, MatrixStack matrixStack, IRenderTypeBuffer buffer, LivingEntity entity, float red, float green, float blue, int light, @Nullable String layer) {
        boolean hasGlint = stack.func_77962_s();
        ResourceLocation texture = new ResourceLocation(stack.func_77973_b().getArmorTexture(stack, (Entity)entity, stack.getEquipmentSlot(), layer));
        RenderType renderType = model.func_228282_a_(texture);
        IVertexBuilder vertexBuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)false, (boolean)hasGlint);
        model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    protected void setPartVisibility(BipedModel<LivingEntity> model, EquipmentSlotType pSlot) {
        model.func_178719_a(false);
        switch (pSlot) {
            case HEAD: {
                model.field_78116_c.field_78806_j = true;
                model.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                model.field_78115_e.field_78806_j = true;
                model.field_178723_h.field_78806_j = true;
                model.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                model.field_78115_e.field_78806_j = true;
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
        }
    }
}

