/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.integrations.perms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;

public class WyPermissions {
    public static final Permission REMOVE_DF_COMMAND = new Permission("command.removedf");
    public static final Permission REMOVE_DF_COMMAND_SELF = new Permission("command.removedf.self");
    public static final Permission ABILITY_PROTECTION_COMMAND = new Permission("command.ability_protection");
    public static final Permission CHECK_FRUITS_COMMAND_LIST = new Permission("command.check_fruits.list");
    public static final Permission CHECK_FRUITS_COMMAND_HISTORY = new Permission("command.check_fruits.history");
    public static final Permission CHECK_PLAYER_COMMAND = new Permission("command.check_player");
    public static final Permission ISSUE_BOUNTY_COMMAND = new Permission("command.issue_bounty");
    public static final Permission ABILITY_COMMAND = new Permission("command.ability");
    public static final Permission ABILITY_COMMAND_RESET_COOLDOWN = new Permission("command.ability.reset_cooldown");
    public static final Permission BELLY_COMMAND = new Permission("command.belly");
    public static final Permission EXTOL_COMMAND = new Permission("command.extol");
    public static final Permission BOUNTY_COMMAND = new Permission("command.bounty");
    public static final Permission DORIKI_COMMAND = new Permission("command.doriki");
    public static final Permission HAKIEXP_COMMAND = new Permission("command.hakiexp");
    public static final Permission LOYALTY_COMMAND = new Permission("command.loyalty");
    public static final Permission QUEST_COMMAND = new Permission("command.quest");
    public static final Permission CHALLENGE_COMMAND = new Permission("command.challenge");
    public static final Permission CHANGE_CHARACTER_COMMAND = new Permission("command.change_character");
    public static final Permission EVENTS_COMMAND = new Permission("command.events");
    public static final Permission BUSTER_CALL_ITEM = new Permission("item.buster_call");

    public static void init() {
        LogManager.getLogger(ModMain.class).info("Permissions registered:");
        Collections.sort(Permission.PERMISSIONS, (p1, p2) -> p1.name.compareToIgnoreCase(p2.name));
        for (Permission perm : Permission.PERMISSIONS) {
            String node = PermissionAPI.registerNode((String)perm.name, (DefaultPermissionLevel)perm.level, (String)perm.name);
            LogManager.getLogger(ModMain.class).info("  " + node);
        }
    }

    public static boolean hasPermission(PlayerEntity player, Permission permission) {
        if (!CommonConfig.INSTANCE.hasPermissionsEnabled()) {
            return false;
        }
        return PermissionAPI.hasPermission((PlayerEntity)player, (String)permission.name);
    }

    public static class Permission {
        private static final List<Permission> PERMISSIONS = new ArrayList<Permission>();
        public final String name;
        public final DefaultPermissionLevel level;

        public Permission(String name) {
            this(name, DefaultPermissionLevel.ALL);
        }

        public Permission(String name, DefaultPermissionLevel level) {
            this.name = "mineminenomi." + name;
            this.level = level;
            PERMISSIONS.add(this);
        }
    }
}

