/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.interactions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.api.poi.NewsEntry;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18nInteractions;
import xyz.pixelatedw.mineminenomi.init.ModInteractions;

public class BarkeeperNewsInteraction
extends Interaction {
    public BarkeeperNewsInteraction() {
    }

    public BarkeeperNewsInteraction(ITextComponent title) {
        super(title);
    }

    public static BarkeeperNewsInteraction news() {
        BarkeeperNewsInteraction interaction = new BarkeeperNewsInteraction((ITextComponent)ModI18nInteractions.NEWS_TITLE);
        interaction.setTriggerAction(interaction::news);
        interaction.setInteractions(ModInteractions.BARKEEPER_RUMOR_CONTINUE);
        return interaction;
    }

    public static BarkeeperNewsInteraction close() {
        BarkeeperNewsInteraction interaction = new BarkeeperNewsInteraction((ITextComponent)ModI18nInteractions.CONTINUE_TITLE);
        interaction.setTriggerAction(interaction::closeMenu);
        return interaction;
    }

    public Interaction.InteractionResult closeMenu(PlayerEntity player, LivingEntity entity) {
        return Interaction.InteractionResult.close();
    }

    public Interaction.InteractionResult news(PlayerEntity player, LivingEntity entity) {
        NewsEntry newsEntry;
        NPCWorldData npcWorldData = NPCWorldData.get();
        EventsWorldData eventWorldData = EventsWorldData.get();
        List trackedList = eventWorldData.getNotoriousTargets().stream().map(target -> target.getTrackedNPC()).collect(Collectors.toList());
        TrackedNPC tracked = null;
        if (trackedList != null && !trackedList.isEmpty()) {
            Collections.shuffle(trackedList);
            tracked = (TrackedNPC)trackedList.get(0);
        } else {
            trackedList = new ArrayList<TrackedNPC>(npcWorldData.getTrackedMobs());
            Collections.shuffle(trackedList);
            tracked = (TrackedNPC)trackedList.get(0);
        }
        if (tracked != null && (newsEntry = tracked.getNewsEntry(player.field_70170_p)) != null) {
            if (newsEntry.getMessage() == null) {
                return Interaction.InteractionResult.close();
            }
            this.setMessage((ITextComponent)newsEntry.getMessage());
        }
        return Interaction.InteractionResult.continueInteraction();
    }
}

