/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.interactions;

import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.api.poi.NTEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.POIEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18nInteractions;
import xyz.pixelatedw.mineminenomi.init.ModInteractions;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class BarkeeperRumorInteraction
extends Interaction {
    private static final int PRICE = 10;
    private static final String[] PIRATE_MESSAGES = new String[]{ModI18nInteractions.NOTORIOUS_PIRATE_RUMOR_1_MESSAGE, ModI18nInteractions.NOTORIOUS_PIRATE_RUMOR_2_MESSAGE};
    private static final String[] MARINE_MESSAGES = new String[]{ModI18nInteractions.NOTORIOUS_MARINE_RUMOR_1_MESSAGE, ModI18nInteractions.NOTORIOUS_MARINE_RUMOR_2_MESSAGE};

    public BarkeeperRumorInteraction() {
    }

    public BarkeeperRumorInteraction(ITextComponent title) {
        super(title);
    }

    public static BarkeeperRumorInteraction rumor() {
        TranslationTextComponent title = new TranslationTextComponent(ModI18nInteractions.RUMORS_WITH_PRICE_TITLE, new Object[]{10});
        BarkeeperRumorInteraction interaction = new BarkeeperRumorInteraction((ITextComponent)title);
        interaction.setTriggerAction(interaction::rumor);
        interaction.setInteractions(ModInteractions.BARKEEPER_RUMOR_CONTINUE);
        return interaction;
    }

    public static BarkeeperRumorInteraction close() {
        BarkeeperRumorInteraction interaction = new BarkeeperRumorInteraction((ITextComponent)ModI18nInteractions.CONTINUE_TITLE);
        interaction.setTriggerAction(interaction::closeMenu);
        return interaction;
    }

    public static BarkeeperRumorInteraction noEvent() {
        BarkeeperRumorInteraction interaction = new BarkeeperRumorInteraction();
        interaction.setMessage((ITextComponent)ModI18nInteractions.BARKEEPER_NO_RUMOR_MESSAGE);
        interaction.setInteractions(ModInteractions.BARKEEPER_RUMOR_CONTINUE);
        return interaction;
    }

    public static BarkeeperRumorInteraction noBelly() {
        BarkeeperRumorInteraction interaction = new BarkeeperRumorInteraction();
        interaction.setMessage((ITextComponent)ModI18nInteractions.BARKEEPER_NO_BELLY_MESSAGE);
        interaction.setInteractions(ModInteractions.BARKEEPER_RUMOR_CONTINUE);
        return interaction;
    }

    public Interaction.InteractionResult closeMenu(PlayerEntity player, LivingEntity entity) {
        return Interaction.InteractionResult.close();
    }

    public Interaction.InteractionResult rumor(PlayerEntity player, LivingEntity entity) {
        boolean isMarine;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getBelly() < 10L) {
            return Interaction.InteractionResult.next((Interaction)ModInteractions.BARKEEPER_RUMOR_NO_BELLY.get());
        }
        props.alterBelly(-10L, StatChangeSource.STORE);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
        boolean bl = isMarine = props.isMarine() || props.isBountyHunter();
        if (isMarine) {
            return this.findTargetEvent(player, entity, true);
        }
        int kind = this.getRandom().nextInt(2);
        if (kind == 0) {
            return this.findTargetEvent(player, entity, false);
        }
        if (kind == 1) {
            return this.findCaravanEvent(player, entity);
        }
        return Interaction.InteractionResult.close();
    }

    private Interaction.InteractionResult findCaravanEvent(PlayerEntity player, LivingEntity entity) {
        EventsWorldData eventsWorldData = EventsWorldData.get();
        Optional<POIEventTarget> event = eventsWorldData.getCaravanPOIs().stream().map(ev -> ImmutablePair.of((Object)ev, (Object)ev.getPosition().func_72438_d(entity.func_213303_ch()))).sorted((p1, p2) -> (Double)p2.right - (Double)p1.right > 0.0 ? 1 : -1).map(pair -> (POIEventTarget)pair.left).findFirst();
        if (!event.isPresent()) {
            return Interaction.InteractionResult.next((Interaction)ModInteractions.BARKEEPER_RUMOR_NONE.get());
        }
        String locationString = (int)event.get().getPosition().field_72450_a + " " + (int)event.get().getPosition().field_72448_b + " " + (int)event.get().getPosition().field_72449_c;
        TranslationTextComponent message = new TranslationTextComponent(ModI18nInteractions.CARAVAN_RUMOR_1_MESSAGE, new Object[]{locationString});
        this.setMessage((ITextComponent)message);
        player.func_145747_a(this.getMessage(), Util.field_240973_b_);
        return Interaction.InteractionResult.continueInteraction();
    }

    private Interaction.InteractionResult findTargetEvent(PlayerEntity player, LivingEntity entity, boolean isMarine) {
        EventsWorldData eventsWorldData = EventsWorldData.get();
        Optional<NTEventTarget> event = eventsWorldData.getNotoriousTargets().stream().filter(ev -> !isMarine || !ev.getTrackedNPC().isMarine()).map(ev -> ImmutablePair.of((Object)ev, (Object)ev.getPosition().func_72438_d(entity.func_213303_ch()))).sorted((p1, p2) -> (Double)p2.right - (Double)p1.right > 0.0 ? 1 : -1).map(pair -> (NTEventTarget)pair.left).findFirst();
        if (!event.isPresent()) {
            return Interaction.InteractionResult.next((Interaction)ModInteractions.BARKEEPER_RUMOR_NONE.get());
        }
        TrackedNPC npc = event.get().getTrackedNPC();
        String npcName = npc.createTrackedMob(entity.field_70170_p).func_145748_c_().getString();
        String locationString = (int)event.get().getPosition().field_72450_a + " " + (int)event.get().getPosition().field_72448_b + " " + (int)event.get().getPosition().field_72449_c;
        TranslationTextComponent message = null;
        if (npc.getFaction().equals((Object)ModValues.PIRATE)) {
            message = new TranslationTextComponent(PIRATE_MESSAGES[this.getRandom().nextInt(PIRATE_MESSAGES.length)], new Object[]{locationString, npcName});
        } else if (event.get().getTrackedNPC().getFaction().equals((Object)ModValues.MARINE)) {
            message = new TranslationTextComponent(MARINE_MESSAGES[this.getRandom().nextInt(MARINE_MESSAGES.length)], new Object[]{locationString, npcName});
        }
        this.setMessage((ITextComponent)message);
        player.func_145747_a(this.getMessage(), Util.field_240973_b_);
        return Interaction.InteractionResult.continueInteraction();
    }
}

