/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFifthAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoDawnWhipAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoGigantAbility;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.IFruitColor;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.enums.AbilityCommandGroup;
import xyz.pixelatedw.mineminenomi.api.enums.FruitType;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.EatDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;
import xyz.pixelatedw.mineminenomi.entities.DFItemEntity;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProgressionEvents;
import xyz.pixelatedw.mineminenomi.events.devilfruits.RandomFruitEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AkumaNoMiItem
extends Item
implements IFruitColor {
    private String name;
    private int tier;
    public FruitType type;
    private AbilityCore<?>[] abilities = new AbilityCore[0];
    private static final int GENERIC_FRUIT_VARIATIONS = 10;
    private static final Color[] STEM_COLORS = new Color[]{WyHelper.hexToRGB("#ccc774"), WyHelper.hexToRGB("#8a5216"), WyHelper.hexToRGB("#025f00"), WyHelper.hexToRGB("#aecd6d"), WyHelper.hexToRGB("#f56fe3"), WyHelper.hexToRGB("#f93434")};

    public AkumaNoMiItem(String name, int tier, FruitType type, AbilityCore<?> ... abilitiesArray) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.DEVIL_FRUITS).func_200917_a(1).func_221540_a(Foods.field_221425_a));
        this.name = name;
        this.type = type;
        this.abilities = abilitiesArray;
        this.tier = tier;
        if (name.equals("Mochi Mochi no Mi") && !WyHelper.isAprilFirst()) {
            return;
        }
        if (this.type == FruitType.LOGIA) {
            ModValues.LOGIA_FRUITS.add(this);
        }
        ModValues.DEVIL_FRUITS.add(this);
    }

    public void setAbilities(AbilityCore<?>[] abilities) {
        this.abilities = abilities;
        AbilityCommandGroup.create(this.name.toUpperCase().replaceAll("[\\'\\:\\-\\,\\#]", "").replaceAll(" ", "_"), () -> this.abilities);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return itemStack;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        EatDevilFruitEvent.Pre preEvent = new EatDevilFruitEvent.Pre(player, itemStack);
        if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
            return itemStack;
        }
        if (!player.field_70170_p.field_72995_K) {
            IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
            OFPWWorldData worldData = OFPWWorldData.get();
            AkumaNoMiItem eatenItem = (AkumaNoMiItem)itemStack.func_77973_b();
            ResourceLocation eatenFruit = eatenItem.getRegistryName();
            boolean hasFruit = devilFruitProps.hasAnyDevilFruit();
            boolean hasYami = devilFruitProps.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI);
            if (CommonConfig.INSTANCE.getRandomizedFruits()) {
                eatenItem = eatenItem.getShiftedFruit(world);
                eatenFruit = eatenItem.getRegistryName();
            }
            boolean flag = worldData.isFruitInUse(eatenFruit);
            if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic() && (flag |= !worldData.updateOneFruit(eatenFruit, player.func_110124_au(), OneFruitEntry.Status.IN_USE))) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_MESSAGE_FRUIT_ALREADY_USED), Util.field_240973_b_);
                itemStack.func_190918_g(1);
                return itemStack;
            }
            if (!CommonConfig.INSTANCE.isYamiPowerEnabled() && hasFruit) {
                this.applyCurseDeath(player);
                itemStack.func_190918_g(1);
                worldData.lostOneFruit(eatenFruit, (LivingEntity)player, "Devil Fruits Curse");
                return itemStack;
            }
            if (CommonConfig.INSTANCE.isYamiPowerEnabled()) {
                if (hasFruit && eatenItem != ModAbilities.YAMI_YAMI_NO_MI && !hasYami) {
                    this.applyCurseDeath(player);
                    itemStack.func_190918_g(1);
                    worldData.lostOneFruit(eatenFruit, (LivingEntity)player, "Devil Fruits Curse");
                    return itemStack;
                }
                if (eatenItem == ModAbilities.YAMI_YAMI_NO_MI && hasYami) {
                    this.applyCurseDeath(player);
                    itemStack.func_190918_g(1);
                    worldData.lostOneFruit(eatenFruit, (LivingEntity)player, "Devil Fruits Curse");
                    return itemStack;
                }
                if (hasFruit && !devilFruitProps.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI) && devilFruitProps.hasYamiPower()) {
                    this.applyCurseDeath(player);
                    itemStack.func_190918_g(1);
                    worldData.lostOneFruit(eatenFruit, (LivingEntity)player, "Devil Fruits Curse");
                    return itemStack;
                }
            }
            if (eatenItem == ModAbilities.YAMI_YAMI_NO_MI && CommonConfig.INSTANCE.isYamiPowerEnabled()) {
                devilFruitProps.setYamiPower(true);
            }
            if (!hasFruit || hasYami && CommonConfig.INSTANCE.isYamiPowerEnabled()) {
                DFEncyclopediaEntry elements = eatenItem.getRandomElements((IWorld)world);
                ItemsHelper.updateEncyclopediae(player, eatenFruit, elements);
                devilFruitProps.setDevilFruit(eatenItem);
                WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), player);
            }
            if (player instanceof ServerPlayerEntity) {
                ModAdvancements.CONSUME_DEVIL_FRUIT.trigger((ServerPlayerEntity)player, this.getRegistryName());
            }
            if (eatenItem != ModAbilities.YOMI_YOMI_NO_MI) {
                for (AbilityCore<?> core : eatenItem.abilities) {
                    if (AbilityHelper.verifyIfAbilityIsBanned(core) || abilityDataProps.hasUnlockedAbility(core)) continue;
                    AbilityHelper.checkAndUnlockAbility(livingEntity, core);
                }
                if (eatenItem == ModAbilities.KAGE_KAGE_NO_MI || eatenItem == ModAbilities.ITO_ITO_NO_MI) {
                    AbilityHelper.checkAndUnlockAbility(livingEntity, CommandAbility.INSTANCE);
                }
                WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), player);
                WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityDataProps), player);
            }
            if (eatenItem == ModAbilities.HITO_HITO_NO_MI) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_MESSAGE_GAINED_ENLIGHTENMENT), Util.field_240973_b_);
                AbilityProgressionEvents.checkForRacialUnlocks(player);
            }
            player.func_213357_a(world, itemStack);
        }
        EatDevilFruitEvent.Post postEvent = new EatDevilFruitEvent.Post(player, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        itemStack.func_190918_g(1);
        return itemStack;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag par4) {
        if (!RandomFruitEvents.Client.HAS_RANDOMIZED_FRUIT) {
            for (int i = 0; i < this.abilities.length; ++i) {
                if (this.abilities[i] == null || AbilityHelper.verifyIfAbilityIsBanned(this.abilities[i]) || this.abilities[i].isHidden() || this.abilities[i] == GearFifthAbility.INSTANCE || this.abilities[i] == GomuGomuNoDawnWhipAbility.INSTANCE || this.abilities[i] == GomuGomuNoGigantAbility.INSTANCE) continue;
                list.add((ITextComponent)this.abilities[i].getLocalizedName().func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY)));
            }
            list.add((ITextComponent)new StringTextComponent(" "));
            list.add((ITextComponent)new StringTextComponent(this.type.getColor() + this.type.getName()));
        } else {
            list.clear();
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemStack) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return null;
        }
        this.applyRandomness(world, itemStack);
        DFItemEntity newEntity = new DFItemEntity(world, entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c, itemStack);
        newEntity.func_200216_c(((ItemEntity)entity).func_200214_m());
        newEntity.func_174867_a(40);
        AbilityHelper.setDeltaMovement((Entity)newEntity, entity.func_213322_ci());
        return newEntity;
    }

    public boolean onEntityItemUpdate(ItemStack itemStack, ItemEntity entity) {
        List foxes;
        List hopperMinecarts;
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        OFPWWorldData worldData = OFPWWorldData.get();
        ResourceLocation fruitKey = this.getRegistryName();
        boolean shouldRemove = false;
        String removeReason = null;
        List<BlockPos> blockPosList = WyHelper.getNearbyTileEntities(entity.func_233580_cy_(), entity.field_70170_p, 2);
        for (BlockPos pos : blockPosList) {
            TileEntity te = entity.field_70170_p.func_175625_s(pos);
            if (!(te instanceof HopperTileEntity)) continue;
            shouldRemove = true;
            removeReason = "Thrown into hopper";
            break;
        }
        if ((hopperMinecarts = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 0.5, null, HopperMinecartEntity.class)).size() > 0) {
            shouldRemove = true;
            removeReason = "Thrown into Hopper Minecart";
        }
        if ((foxes = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 1.5, null, FoxEntity.class)).size() > 0) {
            shouldRemove = true;
            removeReason = "Fox took fruit";
        }
        if (shouldRemove) {
            entity.func_70106_y();
            if (entity.func_200214_m() != null) {
                PlayerEntity thrower = entity.field_70170_p.func_217371_b(entity.func_200214_m());
                if (thrower != null) {
                    thrower.field_71071_by.func_70441_a(itemStack);
                } else {
                    worldData.lostOneFruit(fruitKey, null, removeReason);
                }
            } else {
                worldData.lostOneFruit(fruitKey, null, removeReason);
            }
        }
        return false;
    }

    public void applyRandomness(@Nullable World world, ItemStack itemStack) {
        if (RandomFruitEvents.Client.HAS_RANDOMIZED_FRUIT) {
            RandomFruitEvents.Client.DIRTY = true;
            if (!this.hasBaseColor(itemStack) || !this.hasStemColor(itemStack) || RandomFruitEvents.Client.DIRTY) {
                this.removeBaseColor(itemStack);
                this.removeStemColor(itemStack);
                AkumaNoMiItem randomFruit = this.getShiftedFruit(world);
                DFEncyclopediaEntry randomElements = randomFruit.getRandomElements((IWorld)world);
                if (randomElements == null) {
                    return;
                }
                this.setBaseColor(itemStack, randomElements.getBaseColor().get().getRGB());
                this.setStemColor(itemStack, randomElements.getStemColor().get().getRGB());
                int type = randomElements.getShape().get();
                itemStack.func_196082_o().func_74768_a("type", type);
                itemStack.func_200302_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_GENERIC_FRUIT));
                RandomFruitEvents.Client.DIRTY = false;
            }
        }
    }

    public DFEncyclopediaEntry getRandomElements(@Nullable IWorld world) {
        if (this.getRegistryName() == null) {
            return null;
        }
        long seed = RandomFruitEvents.Common.SEED + (long)this.getRegistryName().hashCode();
        if (world == null || world.func_201670_d()) {
            seed = RandomFruitEvents.Client.FRUIT_SEEDS.get(this.getRegistryName().hashCode());
        }
        Random rand = new Random(seed);
        float red = rand.nextFloat();
        float green = rand.nextFloat();
        float blue = rand.nextFloat();
        Optional<Integer> type = Optional.of(rand.nextInt(10) + 1);
        Optional<Color> baseColor = Optional.of(new Color(red, green, blue));
        Optional<Color> stemColor = Optional.of(STEM_COLORS[rand.nextInt(STEM_COLORS.length)]);
        return DFEncyclopediaEntry.of(type, baseColor, stemColor);
    }

    public AkumaNoMiItem getShiftedFruit(World world) {
        int seed = Math.max(1, (int)(RandomFruitEvents.Common.SEED % 10L));
        int pos = ModValues.DEVIL_FRUITS.indexOf(this);
        int shifted = (pos + seed) % ModValues.DEVIL_FRUITS.size();
        AkumaNoMiItem randomFruit = ModValues.DEVIL_FRUITS.get(shifted);
        return randomFruit;
    }

    @Nullable
    public AkumaNoMiItem getReverseShiftedFruit(World world) {
        for (AkumaNoMiItem fruit : ModValues.DEVIL_FRUITS) {
            AkumaNoMiItem shiftedFruit = fruit.getShiftedFruit(world);
            if (shiftedFruit != this) continue;
            return fruit;
        }
        return null;
    }

    private void applyCurseDeath(PlayerEntity player) {
        player.func_70097_a((DamageSource)ModDamageSource.DEVILS_CURSE, Float.MAX_VALUE);
    }

    public String getFruitKey() {
        try {
            return this.getRegistryName().toString();
        }
        catch (Exception e) {
            LogManager.getLogger((Object)this).warn("Registry name for " + this.func_77658_a() + " could not be found! This could mean a faulty or non-existent registry entry for this fruit.");
            e.printStackTrace();
            return "unknown";
        }
    }

    public AbilityCore<?>[] getAbilities() {
        return this.abilities;
    }

    public int getTier() {
        return this.tier;
    }

    public FruitType getType() {
        return this.type;
    }

    public String getDevilFruitName() {
        return this.name;
    }
}

