/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.events.devilfruits.RandomFruitEvents;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenEncyclopediaScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class DFEncyclopediaItem
extends Item {
    private static final ITextComponent CONFIG_ERROR = ModI18n.SYSTEM_MESSAGE_RANDOMIZED_FRUITS.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED));

    public DFEncyclopediaItem() {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.MISC).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (!CommonConfig.INSTANCE.getRandomizedFruits()) {
            player.func_145747_a((ITextComponent)ModI18n.SYSTEM_MESSAGE_RANDOMIZED_FRUITS, Util.field_240973_b_);
            return ActionResult.func_226251_d_((Object)itemStack);
        }
        WyNetwork.sendTo(new SOpenEncyclopediaScreenPacket(itemStack), (PlayerEntity)((ServerPlayerEntity)player));
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag par4) {
        if (CommonConfig.INSTANCE.getRandomizedFruits() || RandomFruitEvents.Client.HAS_RANDOMIZED_FRUIT) {
            int count = itemStack.func_190925_c("unlocked").func_186856_d();
            list.add((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_DF_ENCYCLOPEDIA_ENTRIES, new Object[]{count}));
            float completeness = DFEncyclopediaItem.getCompletion(itemStack);
            if (completeness > 0.0f) {
                list.add((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_DF_ENCYCLOPEDIA_COMPLETION, new Object[]{String.format("%.2f", Float.valueOf(completeness * 100.0f)) + "%"}));
            }
        } else {
            list.add(CONFIG_ERROR);
        }
    }

    public static void addFruitClues(ItemStack itemStack, ResourceLocation fruit, DFEncyclopediaEntry clue) {
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get()) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        if (clue.getShape().isPresent()) {
            nbt.func_74768_a("shape", clue.getShape().get().intValue());
        }
        if (clue.getBaseColor().isPresent()) {
            nbt.func_74768_a("baseColor", clue.getBaseColor().get().getRGB());
        }
        if (clue.getStemColor().isPresent()) {
            nbt.func_74768_a("stemColor", clue.getStemColor().get().getRGB());
        }
        itemStack.func_190925_c("unlocked").func_218657_a(fruit.toString(), (INBT)nbt);
    }

    public static Set<DFEncyclopediaEntry> getEntries(ItemStack itemStack) {
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get() || !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("unlocked")) {
            return Sets.newHashSet();
        }
        HashSet<DFEncyclopediaEntry> entries = new HashSet<DFEncyclopediaEntry>();
        CompoundNBT nbt = itemStack.func_190925_c("unlocked");
        for (AkumaNoMiItem fruit : ModValues.DEVIL_FRUITS) {
            String key = fruit.getFruitKey();
            if (!nbt.func_74764_b(key)) continue;
            CompoundNBT fruitNbt = nbt.func_74775_l(key);
            Optional<Integer> shape = fruitNbt.func_74764_b("shape") ? Optional.of(fruitNbt.func_74762_e("shape")) : Optional.empty();
            Optional<Color> baseColor = fruitNbt.func_74764_b("baseColor") ? Optional.of(new Color(fruitNbt.func_74762_e("baseColor"))) : Optional.empty();
            Optional<Color> stemColor = fruitNbt.func_74764_b("stemColor") ? Optional.of(new Color(fruitNbt.func_74762_e("stemColor"))) : Optional.empty();
            DFEncyclopediaEntry entry = DFEncyclopediaEntry.of(shape, baseColor, stemColor);
            entry.setDevilFruit(fruit);
            entries.add(entry);
        }
        return entries;
    }

    public static float getCompletion(ItemStack itemStack) {
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get() || !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("unlocked")) {
            return -1.0f;
        }
        int completed = 0;
        CompoundNBT unlockedElements = itemStack.func_179543_a("unlocked");
        for (String key : unlockedElements.func_150296_c()) {
            CompoundNBT nbt = unlockedElements.func_74775_l(key);
            DFEncyclopediaEntry entry = DFEncyclopediaEntry.of(nbt);
            completed += entry.getCompletion();
        }
        return (float)completed / (float)(ModValues.DEVIL_FRUITS.size() * 3);
    }
}

