/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.helpers.SoulboundItemHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class HeartItem
extends Item {
    public HeartItem() {
        super(new Item.Properties().func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        if (itemStack.func_77978_p() == null) {
            player.field_71071_by.func_184437_d(itemStack);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        LivingEntity owner = (LivingEntity)SoulboundItemHelper.getOwner(world, itemStack).getValue();
        if (owner == null) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        IEntityStats props = EntityStatsCapability.get(owner);
        if (props.hasHeart()) {
            player.field_71071_by.func_184437_d(itemStack);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        if (itemStack.func_77978_p() != null) {
            if (owner == player) {
                props.setHeart(true);
                WyNetwork.sendToServer(new SSyncEntityStatsPacket(player.func_145782_y(), props));
                player.field_71071_by.func_184437_d(itemStack);
            } else {
                owner.func_70097_a(this.getDamageSource((LivingEntity)player), 5.0f);
                owner.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 1));
                owner.func_195064_c(new EffectInstance(Effects.field_76431_k, 40, 1));
                if (owner.func_110143_aJ() <= 0.0f) {
                    player.field_71071_by.func_184437_d(itemStack);
                }
            }
        }
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    public boolean onEntityItemUpdate(ItemStack itemStack, ItemEntity entityItem) {
        if (entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        if (itemStack.func_77978_p() != null) {
            boolean isInVoid;
            Pair<UUID, LivingEntity> target = SoulboundItemHelper.getOwner(entityItem.field_70170_p, itemStack);
            boolean isBurning = entityItem.func_70027_ad();
            boolean bl = isInVoid = entityItem.func_233580_cy_().func_177956_o() < -1;
            if (isBurning || isInVoid) {
                if (target.getValue() != null) {
                    for (ItemStack stack : ((LivingEntity)target.getValue()).func_184214_aD()) {
                        if (stack.func_77973_b() != Items.field_190929_cY) continue;
                        stack.func_190918_g(stack.func_190916_E());
                    }
                    ((LivingEntity)target.getValue()).func_70097_a(this.getDamageSource(null), Float.MAX_VALUE);
                } else {
                    ExtendedWorldData.get().markDead((UUID)target.getKey());
                }
            }
        }
        return false;
    }

    private DamageSource getDamageSource(@Nullable LivingEntity entity) {
        if (entity == null) {
            return new ModDamageSource("heart_damage").setInternal().func_82726_p().func_76359_i().func_151518_m();
        }
        return new ModEntityDamageSource("heart_damage", (Entity)entity).setInternal().func_82726_p().func_76359_i().func_151518_m();
    }
}

