/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.SoulboundMark;
import xyz.pixelatedw.mineminenomi.api.helpers.SoulboundItemHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class StrawDollItem
extends Item
implements IDyeableArmorItem {
    public StrawDollItem() {
        super(new Item.Properties().func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        if (itemStack.func_77978_p() == null) {
            player.field_71071_by.func_184437_d(itemStack);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        LivingEntity owner = (LivingEntity)SoulboundItemHelper.getOwner(world, itemStack).getValue();
        if (owner == null) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        IEntityStats props = EntityStatsCapability.get(owner);
        if (props.hasStrawDoll()) {
            player.field_71071_by.func_184437_d(itemStack);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        if (itemStack.func_77978_p() != null && owner == player) {
            props.setStrawDoll(true);
            WyNetwork.sendToServer(new SSyncEntityStatsPacket(player.func_145782_y(), props));
            player.field_71071_by.func_184437_d(itemStack);
        }
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    public boolean onEntityItemUpdate(ItemStack itemStack, ItemEntity entityItem) {
        if (entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        if (itemStack.func_77978_p() != null) {
            boolean isInVoid;
            Pair<UUID, LivingEntity> target = SoulboundItemHelper.getOwner(entityItem.field_70170_p, itemStack);
            boolean isBurning = entityItem.func_70027_ad();
            boolean bl = isInVoid = entityItem.func_233580_cy_().func_177956_o() < -1;
            if (isBurning || isInVoid) {
                if (target.getValue() != null) {
                    for (ItemStack stack : ((LivingEntity)target.getValue()).func_184214_aD()) {
                        if (stack.func_77973_b() != Items.field_190929_cY) continue;
                        stack.func_190918_g(stack.func_190916_E());
                    }
                    EntityStatsCapability.get((LivingEntity)target.getValue()).setStrawDoll(true);
                } else {
                    ExtendedWorldData.get().markRestore((UUID)target.getKey(), SoulboundMark.RESTORE_DOLL);
                }
            }
        }
        return false;
    }

    public static void setStrawDollOwner(ItemStack itemStack, LivingEntity entity) {
        SoulboundItemHelper.setOwner(itemStack, entity);
        float red = entity.func_70681_au().nextFloat();
        float green = entity.func_70681_au().nextFloat();
        float blue = entity.func_70681_au().nextFloat();
        itemStack.func_190925_c("display").func_74768_a("color", new Color(red, green, blue).getRGB());
    }

    public static float getStrawDollHealth(ItemStack itemStack) {
        return itemStack.func_196082_o().func_74760_g("health");
    }

    public static void setStrawDollHealth(ItemStack itemStack, float health) {
        float maxHealth = CommonConfig.INSTANCE.getDorikiLimit() / CommonConfig.INSTANCE.getHealthGainFrequency();
        itemStack.func_196082_o().func_74776_a("health", MathHelper.func_76131_a((float)health, (float)0.0f, (float)maxHealth));
    }

    public static void alterStrawDollHealth(ItemStack itemStack, float health) {
        float maxHealth = CommonConfig.INSTANCE.getDorikiLimit() / CommonConfig.INSTANCE.getHealthGainFrequency();
        float currentHealth = itemStack.func_196082_o().func_74760_g("health");
        itemStack.func_196082_o().func_74776_a("health", MathHelper.func_76131_a((float)(currentHealth + health), (float)0.0f, (float)maxHealth));
    }
}

