/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.weapons;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import xyz.pixelatedw.mineminenomi.abilities.bomu.BreezeBreathBombAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.HissatsuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ModGunItem
extends Item {
    private int maxGunpowder = 3;
    private float bulletSpeed = 2.0f;
    private float bulletAccuracy = 2.0f;
    private int shotCooldown = 10;
    private int reloadCooldown = 20;
    private float damageMultiplier = 1.0f;
    public Predicate<ItemStack> bulletCheck;
    public static final Predicate<ItemStack> GUN_AMMO = itemStack -> itemStack.func_77973_b() == ModItems.BULLET.get() || itemStack.func_77973_b() == ModItems.KAIROSEKI_BULLET.get();
    public static final Predicate<ItemStack> BAZOOKA_AMMO = itemStack -> itemStack.func_77973_b() == ModItems.CANNON_BALL.get();

    public ModGunItem(int maxDamage) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200918_c(maxDamage));
        this.bulletCheck = GUN_AMMO;
    }

    public ModGunItem(int maxDamage, Predicate<ItemStack> bulletPredicate) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200918_c(maxDamage));
        this.bulletCheck = bulletPredicate;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean hasGunPowder;
        boolean flag;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        BreezeBreathBombAbility ability = abilityProps.getEquippedAbility(BreezeBreathBombAbility.INSTANCE);
        boolean hasAbility = ability != null && ability.isContinuous();
        boolean hasBullets = this.findBulletStack(player) != null;
        Item bulletType = this.findBulletStack(player) != null ? this.findBulletStack(player).func_77973_b() : null;
        ItemStack heldItemStack = player.func_184586_b(hand);
        if (hasAbility) {
            this.playLoadSound((LivingEntity)player);
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItemStack);
        }
        boolean bl = flag = !player.func_213356_f(heldItemStack).func_190926_b();
        if (flag) {
            this.playLoadSound((LivingEntity)player);
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItemStack);
        }
        if (!hasBullets || bulletType == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)heldItemStack);
        }
        boolean bl2 = hasGunPowder = this.getLoadedGunPowder(heldItemStack) > 0;
        if (!hasGunPowder) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_77973_b() != Items.field_151016_H) continue;
                int count = this.maxGunpowder;
                if (stack.func_190916_E() < count) {
                    count = stack.func_190916_E();
                }
                this.setLoadedGunPowder(heldItemStack, count * 5);
                player.field_71071_by.func_70298_a(i, count);
                hasGunPowder = true;
                player.func_184811_cZ().func_185145_a((Item)this, this.reloadCooldown);
                break;
            }
        }
        if (!hasGunPowder) {
            return new ActionResult(ActionResultType.FAIL, (Object)heldItemStack);
        }
        this.playLoadSound((LivingEntity)player);
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItemStack);
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entityLiving, int timeLeft) {
        boolean hasInfinite;
        int i;
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        Item bulletType = this.findBulletStack(player) != null ? this.findBulletStack(player).func_77973_b() : null;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        BreezeBreathBombAbility ability = abilityProps.getEquippedAbility(BreezeBreathBombAbility.INSTANCE);
        if (!player.field_70170_p.field_72995_K && ability != null && ability.getComponent(ModAbilityKeys.CONTINUOUS).map(ContinuousComponent::isContinuous).orElse(false).booleanValue()) {
            ability.getComponent(ModAbilityKeys.PROJECTILE).ifPresent(comp -> comp.shoot(entityLiving));
            return;
        }
        int powder = this.getLoadedGunPowder(itemStack);
        if (!world.field_72995_K) {
            boolean flag = player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemStack) > 0;
            i = this.func_77626_a(itemStack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (World)world, (PlayerEntity)player, (int)i, (!itemStack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            boolean isHitScan = HissatsuAbility.checkHitScan((LivingEntity)player);
            int amount = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)itemStack) > 0 ? 3 : 1;
            for (int n = 0; n < amount; ++n) {
                int k;
                AbilityProjectileEntity proj = new NormalBulletProjectile(player.field_70170_p, (LivingEntity)player);
                if (bulletType == ModItems.BULLET.get()) {
                    proj = new NormalBulletProjectile(player.field_70170_p, (LivingEntity)player);
                } else if (bulletType == ModItems.KAIROSEKI_BULLET.get()) {
                    proj = new KairosekiBulletProjectile(player.field_70170_p, (LivingEntity)player);
                } else if (bulletType == ModItems.CANNON_BALL.get()) {
                    proj = new CannonBallProjectile(player.field_70170_p, (LivingEntity)player);
                }
                int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)itemStack);
                if (j > 0) {
                    proj.setDamage((float)((double)proj.getDamage() + (double)j * 0.5 + 0.5));
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)itemStack)) > 0) {
                    proj.setKnockbackStrength(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemStack) > 0) {
                    proj.func_70015_d(100);
                }
                proj.setDamage(Math.round(proj.getDamage() * this.damageMultiplier));
                if (isHitScan) {
                    float distance = proj.getMaxLife();
                    EntityRayTraceResult result = WyHelper.rayTraceEntities((Entity)player, distance, 1.25, ProjectileComponent.TARGET_CHECK);
                    if (result.func_216348_a() == null || !(result.func_216348_a() instanceof LivingEntity)) continue;
                    proj.onModHit((RayTraceResult)result);
                    continue;
                }
                player.field_70170_p.func_217376_c((Entity)proj);
                if (n > 0) {
                    Vector3d vector3d1 = player.func_213286_i(1.0f);
                    Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), n == 1 ? -10.0f : 10.0f, true);
                    Vector3d vector3d = player.func_70676_i(1.0f);
                    Vector3f vector3f = new Vector3f(vector3d);
                    vector3f.func_214905_a(quaternion);
                    proj.func_70186_c(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c(), this.bulletSpeed, this.bulletAccuracy);
                    continue;
                }
                proj.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.bulletSpeed, this.bulletAccuracy);
            }
            this.playShootSound((LivingEntity)player);
            Vector3d lookVec = player.func_70040_Z().func_178785_b((float)Math.toRadians(-30.0));
            Vector3d particlePos = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(lookVec);
            for (int p = 0; p < 10; ++p) {
                if (p % 2 == 0) {
                    WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197598_I, (ServerWorld)player.field_70170_p, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                    continue;
                }
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197601_L, (ServerWorld)player.field_70170_p, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
            }
            itemStack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(player.func_184600_cs()));
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        player.func_184811_cZ().func_185145_a((Item)this, this.shotCooldown);
        boolean bl = hasInfinite = player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemStack) > 0;
        if (hasInfinite) {
            return;
        }
        this.setLoadedGunPowder(itemStack, Math.max(0, --powder));
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.bulletCheck.test(stack)) continue;
            player.field_71071_by.func_70298_a(i, 1);
            break;
        }
    }

    public void playLoadSound(LivingEntity entity) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GUN_LOAD.get(), SoundCategory.PLAYERS, 1.5f, 0.75f + entity.func_70681_au().nextFloat() / 4.0f);
    }

    public void playShootSound(LivingEntity entity) {
        if (this == ModWeapons.FLINTLOCK.get() || this == ModWeapons.WALKER.get()) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 4.0f);
        } else if (this == ModWeapons.BAZOOKA.get()) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GENERIC_EXPLOSION.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 4.0f);
        } else if (this == ModWeapons.SENRIKU.get()) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.SNIPER_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 4.0f);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new CompoundNBT());
            itemStack.func_77978_p().func_74768_a("gunPowder", 0);
        }
    }

    public void setLoadedGunPowder(ItemStack itemStack, int powder) {
        itemStack.func_77978_p().func_74768_a("gunPowder", powder);
    }

    public int getLoadedGunPowder(ItemStack itemStack) {
        return itemStack.func_77978_p().func_74762_e("gunPowder");
    }

    public ItemStack findBulletStack(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.bulletCheck.test(stack)) continue;
            return stack;
        }
        return null;
    }

    public ModGunItem setGunpowderLimit(int limit) {
        this.maxGunpowder = limit;
        return this;
    }

    public ModGunItem setDamageMultiplier(float damage) {
        this.damageMultiplier = damage;
        return this;
    }

    public ModGunItem setShotCooldown(int cd) {
        this.shotCooldown = cd;
        return this;
    }

    public ModGunItem setReloadCooldown(int cd) {
        this.reloadCooldown = cd;
        return this;
    }

    public ModGunItem setBulletAccuracy(float acc) {
        this.bulletAccuracy = acc;
        return this;
    }

    public ModGunItem setBulletSpeed(float speed) {
        this.bulletSpeed = speed;
        return this;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag par4) {
        if (itemStack.func_77942_o()) {
            list.add((ITextComponent)new StringTextComponent("Gun Powder: " + itemStack.func_77978_p().func_74762_e("gunPowder")));
        }
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.BOW || enchantment.field_77351_y == EnchantmentType.BREAKABLE;
    }
}

