/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mixin(value={AbstractBlock.AbstractBlockState.class})
public abstract class AbstractBlockStateMixin {
    @Shadow
    protected abstract BlockState func_230340_p_();

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    public void randomTick(ServerWorld level, BlockPos pos, Random random, CallbackInfo ci) {
        if (WyHelper.isInChallengeDimension((World)level)) {
            ci.cancel();
            return;
        }
    }

    @Inject(method={"getCollisionShape(Lnet/minecraft/world/IBlockReader;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/shapes/ISelectionContext;)Lnet/minecraft/util/math/shapes/VoxelShape;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getCollisionShape(IBlockReader pLevel, BlockPos pPos, ISelectionContext pContext, CallbackInfoReturnable<VoxelShape> cir) {
        Entity entity = pContext.getEntity();
        if (entity instanceof LivingEntity) {
            boolean flagLower;
            boolean flagAllowedToGoThrough = AbilityHelper.isAllowedToGoThrough((LivingEntity)entity, this.func_230340_p_());
            boolean flagCrouching = entity.func_226271_bk_();
            boolean bl = flagLower = (double)pPos.func_177956_o() > entity.func_226278_cu_() - 1.0;
            if (flagAllowedToGoThrough && (flagCrouching || flagLower)) {
                cir.setReturnValue((Object)VoxelShapes.func_197880_a());
            }
        }
    }
}

