/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pixelatedw.mineminenomi.api.AbilityDisplayInfo;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mixin(value={DisplayInfo.class})
public abstract class DisplayInfoMixin {
    @Shadow
    @Final
    private boolean field_193227_g;
    @Shadow
    @Final
    private boolean field_193226_f;

    @Inject(method={"fromJson"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromJson(JsonObject pObject, CallbackInfoReturnable<DisplayInfo> callback) {
        IFormattableTextComponent title = ITextComponent.Serializer.func_240641_a_((JsonElement)pObject.get("title"));
        IFormattableTextComponent desc = ITextComponent.Serializer.func_240641_a_((JsonElement)pObject.get("description"));
        if (title != null && desc != null) {
            JsonObject iconObj = JSONUtils.func_152754_s((JsonObject)pObject, (String)"icon");
            if (iconObj.has("ability")) {
                AbilityCore<?> icon = DisplayInfoMixin.getAbility(iconObj);
                if (icon == null) {
                    return;
                }
                ResourceLocation bg = pObject.has("background") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)pObject, (String)"background")) : null;
                FrameType frame = pObject.has("frame") ? FrameType.func_192308_a((String)JSONUtils.func_151200_h((JsonObject)pObject, (String)"frame")) : FrameType.TASK;
                boolean flag = JSONUtils.func_151209_a((JsonObject)pObject, (String)"show_toast", (boolean)true);
                boolean flag1 = JSONUtils.func_151209_a((JsonObject)pObject, (String)"announce_to_chat", (boolean)true);
                boolean flag2 = JSONUtils.func_151209_a((JsonObject)pObject, (String)"hidden", (boolean)false);
                callback.setReturnValue((Object)new AbilityDisplayInfo(icon, (ITextComponent)title, (ITextComponent)desc, bg, frame, flag, flag1, flag2));
            }
        } else {
            throw new JsonSyntaxException("Both title and description must be set");
        }
    }

    @Nullable
    private static AbilityCore<?> getAbility(JsonObject json) {
        ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"ability"));
        AbilityCore ability = (AbilityCore)ModRegistries.ABILITIES.getValue(key);
        return ability;
    }

    @Inject(method={"serializeToNetwork"}, at={@At(value="HEAD")}, cancellable=true)
    public void serializeToNetwork(PacketBuffer buf, CallbackInfo callback) {
        DisplayInfo info = (DisplayInfo)this;
        if (info instanceof AbilityDisplayInfo) {
            AbilityDisplayInfo ablInfo = (AbilityDisplayInfo)info;
            ResourceLocation rs = new ResourceLocation("mineminenomi", WyHelper.getResourceName(ablInfo.getAbility().getUnlocalizedName()));
            buf.writeInt(1);
            buf.func_192572_a(rs);
        } else {
            buf.writeInt(0);
        }
    }

    @Inject(method={"fromNetwork"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromNetwork(PacketBuffer buf, CallbackInfoReturnable<DisplayInfo> callback) {
        int v = buf.readInt();
        if (v == 1) {
            ResourceLocation rs = buf.func_192575_l();
            AbilityCore ability = (AbilityCore)GameRegistry.findRegistry(AbilityCore.class).getValue(rs);
            ITextComponent itextcomponent = buf.func_179258_d();
            ITextComponent itextcomponent1 = buf.func_179258_d();
            ItemStack itemstack = buf.func_150791_c();
            FrameType frametype = (FrameType)buf.func_179257_a(FrameType.class);
            int i = buf.readInt();
            ResourceLocation resourcelocation = (i & 1) != 0 ? buf.func_192575_l() : null;
            boolean flag = (i & 2) != 0;
            boolean flag1 = (i & 4) != 0;
            AbilityDisplayInfo displayinfo = new AbilityDisplayInfo(ability, itextcomponent, itextcomponent1, resourcelocation, frametype, flag, false, flag1);
            displayinfo.func_192292_a(buf.readFloat(), buf.readFloat());
            callback.setReturnValue((Object)displayinfo);
        }
    }

    @Inject(method={"serializeIcon"}, at={@At(value="HEAD")}, cancellable=true)
    private void serializeIcon(CallbackInfoReturnable<JsonObject> callback) {
        DisplayInfo info = (DisplayInfo)this;
        if (info instanceof AbilityDisplayInfo) {
            AbilityDisplayInfo ablInfo = (AbilityDisplayInfo)info;
            JsonObject jsonobject = new JsonObject();
            if (ablInfo.getAbility() != null) {
                String abilityIcon = ablInfo.getAbility().getRegistryName().toString();
                jsonobject.addProperty("ability", abilityIcon);
            }
            String itemIcon = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)info.func_192298_b().func_77973_b()).toString();
            jsonobject.addProperty("item", itemIcon);
            if (info.func_192298_b().func_77942_o()) {
                jsonobject.addProperty("nbt", info.func_192298_b().func_77978_p().toString());
            }
            callback.setReturnValue((Object)jsonobject);
        }
    }
}

