/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.AbstractRepairContainer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.SmithingTableContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pixelatedw.mineminenomi.api.events.SmithingTableEvent;

@Mixin(value={SmithingTableContainer.class})
public abstract class SmithingTableContainerMixin
extends AbstractRepairContainer {
    @Shadow
    @Final
    private World field_234651_g_;
    @Nullable
    @Shadow
    private SmithingRecipe field_234652_h_;
    private boolean customRecipe;
    private int baseQty;
    private int additionQty;

    public SmithingTableContainerMixin(ContainerType<?> pType, int pContainerId, PlayerInventory pPlayerInventory, IWorldPosCallable pAccess) {
        super(pType, pContainerId, pPlayerInventory, pAccess);
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void createResult(CallbackInfo ci) {
        this.customRecipe = false;
        SmithingTableContainer container = (SmithingTableContainer)this;
        ItemStack leftSlot = this.field_234643_d_.func_70301_a(0);
        ItemStack rightSlot = this.field_234643_d_.func_70301_a(1);
        SmithingTableEvent event = new SmithingTableEvent(container, this.field_234645_f_, leftSlot, rightSlot);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResultSlot().func_190926_b()) {
            return;
        }
        if (leftSlot.func_190916_E() < event.getBaseQuantity() || rightSlot.func_190916_E() < event.getAdditionQuantity()) {
            return;
        }
        this.baseQty = event.getBaseQuantity();
        this.additionQty = event.getAdditionQuantity();
        this.customRecipe = true;
        ItemStack itemstack = event.getResultSlot();
        this.field_234642_c_.func_70299_a(0, itemstack);
        ci.cancel();
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    public void onTake(PlayerEntity player, ItemStack inputItem, CallbackInfoReturnable<ItemStack> cir) {
        if (this.customRecipe) {
            inputItem.func_77980_a(player.field_70170_p, player, inputItem.func_190916_E());
            this.field_234642_c_.func_201560_d(player);
            this.shrinkStackInSlot(0, this.baseQty);
            this.shrinkStackInSlot(1, this.additionQty);
            this.field_234644_e_.func_221486_a((world, pos) -> world.func_217379_c(1044, pos, 0));
            cir.setReturnValue((Object)inputItem);
            return;
        }
    }

    private void shrinkStackInSlot(int index, int qty) {
        ItemStack itemstack = this.field_234643_d_.func_70301_a(index);
        itemstack.func_190918_g(qty);
        this.field_234643_d_.func_70299_a(index, itemstack);
    }

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    public void mayPickup(PlayerEntity player, boolean hasStack, CallbackInfoReturnable<Boolean> cir) {
        if (this.customRecipe) {
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)(this.field_234652_h_ != null && this.field_234652_h_.func_77569_a(this.field_234643_d_, this.field_234651_g_) ? 1 : 0));
    }
}

