/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins.client;

import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

@Mixin(value={BipedModel.class})
public abstract class BipedModelMixin<T extends LivingEntity>
extends AgeableModel<T> {
    @Shadow
    public ModelRenderer field_78116_c;
    @Shadow
    public ModelRenderer field_78115_e;
    @Shadow
    public ModelRenderer field_178723_h;
    @Shadow
    public ModelRenderer field_178724_i;
    @Shadow
    public ModelRenderer field_178721_j;
    @Shadow
    public ModelRenderer field_178722_k;
    @Shadow
    public ModelRenderer field_178720_f;

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")}, cancellable=true)
    public void preSetupAnimation(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callback) {
        IEntityStats props = EntityStatsCapability.get(entity);
        BipedModel model = (BipedModel)this;
        RendererHelper.resetHumanoidModelToDefaultPivots(model);
        boolean isRotationBlocked = entity.func_70651_bq().stream().anyMatch(instance -> instance.func_188419_a() instanceof ModEffect && ((ModEffect)instance.func_188419_a()).isBlockingRotations());
        if (isRotationBlocked) {
            RendererHelper.animationAngles(entity, model, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            callback.cancel();
        }
        if (props.isBlackLeg() && entity.func_184614_ca().func_190926_b()) {
            this.field_217112_c = 0.0f;
        }
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void legKickAnimation(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callback) {
        IEntityStats props = EntityStatsCapability.get(entity);
        if (props.isBlackLeg() && (props.isInCombatMode() || ClientConfig.INSTANCE.isBlackLegAlwaysUp())) {
            if (((LivingEntity)entity).field_70169_q - entity.func_226277_ct_() == 0.0 && ((LivingEntity)entity).field_70166_s - entity.func_226281_cx_() == 0.0 && !entity.func_70644_a((Effect)ModEffects.MOVEMENT_BLOCKED.get())) {
                this.field_178721_j.field_78797_d -= 4.0f;
                this.field_178721_j.field_78798_e -= 3.0f;
            }
            if (((LivingEntity)entity).field_70733_aJ > 0.0f && entity.func_184614_ca().func_190926_b()) {
                float swingProgress = ((LivingEntity)entity).field_70733_aJ;
                this.field_178721_j.field_78795_f -= ((LivingEntity)entity).field_70733_aJ * 2.0f;
                this.field_178721_j.field_78808_h += ((LivingEntity)entity).field_70733_aJ * 2.0f;
                this.field_78115_e.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2))) * 0.2f;
                this.field_178723_h.field_78798_e = MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178723_h.field_78800_c = -MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178724_i.field_78798_e = -MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178724_i.field_78800_c = MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178723_h.field_78796_g += this.field_78115_e.field_78796_g;
                this.field_178724_i.field_78796_g += this.field_78115_e.field_78796_g;
                this.field_178724_i.field_78795_f += this.field_78115_e.field_78796_g;
                this.field_78116_c.func_217177_a(this.field_178720_f);
            }
        }
        BipedModel model = (BipedModel)this;
        RendererHelper.animationAngles(entity, model, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }
}

