/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.models.entities.mobs.animals;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.AbstractDugongEntity;

@OnlyIn(value=Dist.CLIENT)
public class DugongModel<T extends AbstractDugongEntity>
extends AgeableModel<T>
implements IHasArm,
IHasHead {
    private final ModelRenderer head;
    private final ModelRenderer snout;
    private final ModelRenderer headShell;
    private final ModelRenderer body;
    private final ModelRenderer shell;
    private final ModelRenderer lowerBody;
    private final ModelRenderer lowerBody2;
    public final ModelRenderer tailBase;
    private final ModelRenderer tail2;
    private final ModelRenderer tail3;
    private final ModelRenderer tail4;
    private final ModelRenderer tailTip1;
    private final ModelRenderer tailTip2;
    public final ModelRenderer rightArm;
    public final ModelRenderer leftArm;

    public DugongModel() {
        this.field_78090_t = 100;
        this.field_78089_u = 50;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 10.75f, -2.2f);
        this.head.func_78784_a(0, 9).func_228303_a_(-2.5f, -4.75f, -2.6f, 5.0f, 5.0f, 5.0f, 0.0f, false);
        this.snout = new ModelRenderer((Model)this);
        this.snout.func_78793_a(0.0f, -1.25f, -0.7f);
        this.head.func_78792_a(this.snout);
        this.snout.func_78784_a(0, 20).func_228303_a_(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 1.0f, 0.0f, false);
        this.headShell = new ModelRenderer((Model)this);
        this.headShell.func_78793_a(0.0f, -2.55f, 1.7f);
        this.head.func_78792_a(this.headShell);
        this.headShell.func_78784_a(0, 0).func_228303_a_(-3.0f, -2.5f, -2.0f, 6.0f, 5.0f, 3.0f, 0.0f, false);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 15.0f, -2.0f);
        this.body.func_78784_a(21, 0).func_228303_a_(-4.0f, -4.0f, -2.5f, 8.0f, 8.0f, 5.0f, 0.0f, false);
        this.shell = new ModelRenderer((Model)this);
        this.shell.func_78793_a(0.0f, -4.0f, 4.0f);
        this.body.func_78792_a(this.shell);
        this.shell.func_78784_a(21, 25).func_228303_a_(-4.5f, -0.5f, -3.5f, 9.0f, 9.0f, 3.0f, 0.0f, false);
        this.lowerBody = new ModelRenderer((Model)this);
        this.lowerBody.func_78793_a(0.0f, 20.7189f, -0.9321f);
        this.setRotationAngle(this.lowerBody, 0.4363f, 0.0f, 0.0f);
        this.lowerBody.func_78784_a(21, 14).func_228303_a_(-3.0f, -3.0f, -2.0f, 6.0f, 5.0f, 4.0f, 0.0f, false);
        this.lowerBody2 = new ModelRenderer((Model)this);
        this.lowerBody2.func_78793_a(0.0f, 1.25f, 0.0f);
        this.lowerBody.func_78792_a(this.lowerBody2);
        this.setRotationAngle(this.lowerBody2, 0.6981f, 0.0f, 0.0f);
        this.lowerBody2.func_78784_a(0, 35).func_228303_a_(-3.0f, -0.75f, -2.0079f, 6.0f, 2.0f, 3.0f, -0.01f, false);
        this.tailBase = new ModelRenderer((Model)this);
        this.tailBase.func_78793_a(0.0f, 22.1689f, 1.8179f);
        this.setRotationAngle(this.tailBase, 1.5708f, 0.0f, 0.0f);
        this.tailBase.func_78784_a(48, 0).func_228303_a_(-3.0f, -2.0f, -2.0f, 6.0f, 4.0f, 4.0f, 0.01f, false);
        this.tail2 = new ModelRenderer((Model)this);
        this.tail2.func_78793_a(0.0f, 1.1491f, -0.3358f);
        this.tailBase.func_78792_a(this.tail2);
        this.setRotationAngle(this.tail2, 0.6981f, 0.0f, 0.0f);
        this.tail2.func_78784_a(48, 9).func_228303_a_(-2.5f, -0.0912f, -1.3767f, 5.0f, 3.0f, 3.0f, 0.0f, false);
        this.tail3 = new ModelRenderer((Model)this);
        this.tail3.func_78793_a(0.0f, 2.7088f, 0.1233f);
        this.tail2.func_78792_a(this.tail3);
        this.tail3.func_78784_a(48, 16).func_228303_a_(-2.0f, 0.0f, -1.0f, 4.0f, 2.0f, 2.0f, 0.0f, false);
        this.tail4 = new ModelRenderer((Model)this);
        this.tail4.func_78793_a(0.0f, 4.2169f, -1.2119f);
        this.tail3.func_78792_a(this.tail4);
        this.setRotationAngle(this.tail4, -2.9671f, 0.0f, 0.0f);
        this.tail4.func_78784_a(48, 21).func_228303_a_(-0.5f, 0.2856f, -2.0321f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.tailTip1 = new ModelRenderer((Model)this);
        this.tailTip1.func_78793_a(-1.5314f, -0.4396f, -0.3374f);
        this.tail4.func_78792_a(this.tailTip1);
        this.setRotationAngle(this.tailTip1, 0.0f, -0.2269f, 0.3491f);
        this.tailTip1.func_78784_a(48, 25).func_228303_a_(-1.4162f, 0.208f, -2.0917f, 3.0f, 2.0f, 1.0f, 0.0f, false);
        this.tailTip2 = new ModelRenderer((Model)this);
        this.tailTip2.func_78793_a(1.5371f, -0.478f, -0.3502f);
        this.tail4.func_78792_a(this.tailTip2);
        this.setRotationAngle(this.tailTip2, 0.0f, 0.2269f, -0.3491f);
        this.tailTip2.func_78784_a(48, 25).func_228303_a_(-1.5838f, 0.208f, -2.0917f, 3.0f, 2.0f, 1.0f, 0.0f, false);
        this.rightArm = new ModelRenderer((Model)this);
        this.rightArm.func_78793_a(-4.5f, 12.3f, -2.0f);
        this.rightArm.func_78784_a(0, 24).func_228303_a_(-1.5f, -1.0f, -1.5f, 2.0f, 7.0f, 3.0f, 0.0f, false);
        this.leftArm = new ModelRenderer((Model)this);
        this.leftArm.func_78793_a(4.5f, 12.3f, -2.0f);
        this.leftArm.func_78784_a(0, 24).func_228303_a_(-0.5f, -1.0f, -1.5f, 2.0f, 7.0f, 3.0f, 0.0f, true);
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.field_217114_e) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        }
        this.head.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.lowerBody.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tailBase.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightArm.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftArm.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78798_e = -2.2f;
        this.head.field_78797_d = 10.75f;
        this.head.field_78795_f = 0.0f;
        this.rightArm.field_78800_c = -4.5f;
        this.rightArm.field_78797_d = 12.3f;
        this.rightArm.field_78798_e = -1.5f;
        this.leftArm.field_78800_c = 4.5f;
        this.leftArm.field_78797_d = 12.3f;
        this.leftArm.field_78798_e = -1.5f;
        this.rightArm.field_78808_h = 0.0f;
        this.rightArm.field_78796_g = 0.0f;
        this.leftArm.field_78808_h = 0.0f;
        this.leftArm.field_78796_g = 0.0f;
        this.body.field_78798_e = -2.0f;
        this.lowerBody.field_78798_e = -0.9321f;
        this.lowerBody.field_78795_f = 0.4363f;
        this.tailBase.field_78798_e = 1.8179f;
        this.tailBase.field_78797_d = 22.1689f;
        this.tailBase.field_78795_f = 1.5708f;
        this.tail2.field_78795_f = 0.69f;
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        if (((AbstractDugongEntity)entity).isCheering()) {
            this.rightArm.field_78795_f = (float)Math.toRadians(180.0) + MathHelper.func_76126_a((float)((float)((double)ageInTicks * Math.PI * (double)0.3f))) * 0.2f;
            this.leftArm.field_78795_f = (float)Math.toRadians(180.0) + MathHelper.func_76126_a((float)((float)((double)ageInTicks * Math.PI * (double)0.3f))) * 0.2f;
        }
        if (((AbstractDugongEntity)entity).isResting()) {
            this.head.field_78795_f = (float)Math.toRadians(-90.0);
            this.head.field_78798_e = -4.0f;
            this.head.field_78797_d = 9.0f;
            this.rightArm.field_78796_g = (float)Math.toRadians(90.0);
            this.rightArm.field_78795_f = (float)Math.toRadians(-45.0);
            this.rightArm.field_78798_e = -3.5f;
            this.leftArm.field_78796_g = (float)Math.toRadians(-90.0);
            this.leftArm.field_78795_f = (float)Math.toRadians(-45.0);
            this.leftArm.field_78798_e = -3.5f;
            this.lowerBody.field_78795_f = 0.0f;
            this.lowerBody.field_78798_e = -2.0f;
            this.tailBase.field_78795_f = 0.0f;
            this.tailBase.field_78797_d = 23.0f;
            this.tailBase.field_78798_e = -1.95f;
            this.tail2.field_78795_f = 0.0f;
        }
        if (((AbstractDugongEntity)entity).isTraining()) {
            switch (((AbstractDugongEntity)entity).getTrainingMode()) {
                case PUSHUPS: {
                    this.rightArm.field_78795_f = (float)Math.toRadians(-90.0);
                    this.leftArm.field_78795_f = (float)Math.toRadians(-90.0);
                    this.tailBase.field_78795_f = (float)Math.toRadians(30.0);
                    this.lowerBody.field_78795_f = (float)Math.toRadians(0.0);
                    float bodyMovement = -MathHelper.func_76134_b((float)(ageInTicks * 0.5f));
                    this.lowerBody.field_78798_e = -2.0f;
                    this.tailBase.field_78798_e = -1.0f;
                    this.tailBase.field_78797_d = 24.0f;
                    this.body.field_78798_e = this.head.field_78798_e = -0.7f * (3.5f - bodyMovement);
                    break;
                }
                case SHADOW_BOXING: {
                    float rightArmMovement = -MathHelper.func_76134_b((float)(ageInTicks * 1.2f));
                    this.rightArm.field_78798_e = -2.5f * (0.5f - rightArmMovement);
                    this.rightArm.field_78795_f = (float)Math.toRadians(-90.0);
                    this.rightArm.field_78796_g = 0.0f;
                    float leftArmMovement = MathHelper.func_76134_b((float)(ageInTicks * 1.2f));
                    this.leftArm.field_78798_e = -2.5f * (0.5f - leftArmMovement);
                    this.leftArm.field_78795_f = (float)Math.toRadians(-90.0);
                    this.leftArm.field_78796_g = 0.0f;
                    break;
                }
            }
        }
        if (((AbstractDugongEntity)entity).isHappy()) {
            this.tail2.field_78795_f = 0.4f * (0.7f + MathHelper.func_76134_b((float)(ageInTicks * 0.4f)));
            this.tail2.field_78796_g = 0.0f;
            this.tail2.field_78808_h = 0.0f;
            this.tail3.field_78795_f = 0.6f * this.tail2.field_78795_f;
            this.tail3.field_78796_g = 0.0f;
            this.tail3.field_78808_h = 0.0f;
        } else {
            this.tail2.field_78795_f = 0.69f;
            this.tail3.field_78795_f = (float)Math.toRadians(0.0);
            this.tail2.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * 0.4f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.3f;
            this.tail3.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * 0.4f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.3f;
        }
        this.setupAttackAnimation(entity, ageInTicks);
        RendererHelper.animationAngles(entity, this, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    protected void setupAttackAnimation(T entity, float ageInTicks) {
        if (this.field_217112_c > 0.0f) {
            float f = this.field_217112_c;
            this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * ((float)Math.PI * 2))) * 0.2f;
            this.rightArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78795_f += this.body.field_78796_g;
            f = 1.0f - this.field_217112_c;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
            this.rightArm.field_78795_f = (float)((double)this.rightArm.field_78795_f - ((double)f1 * 1.2 + (double)f2));
            this.rightArm.field_78796_g += this.body.field_78796_g * 2.0f;
            this.rightArm.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
    }

    public void setRotationAngle(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public ModelRenderer func_205072_a() {
        return this.head;
    }

    public void func_225599_a_(HandSide side, MatrixStack matrixStack) {
        this.getArm(side).func_228307_a_(matrixStack);
        matrixStack.func_227861_a_(side == HandSide.RIGHT ? 0.03 : -0.03, -0.2, 0.0);
    }

    protected ModelRenderer getArm(HandSide side) {
        return side == HandSide.LEFT ? this.leftArm : this.rightArm;
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.lowerBody, (Object)this.rightArm, (Object)this.leftArm, (Object)this.tailBase);
    }
}

