/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.charactercreator.CharacterCreatorEntry;
import xyz.pixelatedw.mineminenomi.api.charactercreator.FactionId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.RaceId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.StyleId;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.CharacterCreatorItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CFinishCCPacket {
    private int factionId;
    private int raceId;
    private int styleId;
    private int minkRaceId;

    public CFinishCCPacket() {
    }

    public CFinishCCPacket(int factionId, int raceId, int styleId, int minkRaceId) {
        this.factionId = factionId;
        this.raceId = raceId;
        this.styleId = styleId;
        this.minkRaceId = minkRaceId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.factionId);
        buffer.writeInt(this.raceId);
        buffer.writeInt(this.styleId);
        buffer.writeInt(this.minkRaceId);
    }

    public static CFinishCCPacket decode(PacketBuffer buffer) {
        CFinishCCPacket msg = new CFinishCCPacket();
        msg.factionId = buffer.readInt();
        msg.raceId = buffer.readInt();
        msg.styleId = buffer.readInt();
        msg.minkRaceId = buffer.readInt();
        return msg;
    }

    public static void handle(CFinishCCPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                boolean hasEmptyStats;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
                IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
                Random rand = new Random();
                boolean hasCharBook = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().equals(ModItems.CHARACTER_CREATOR.get());
                boolean bl = hasEmptyStats = !entityProps.hasFaction() || !entityProps.hasFightingStyle() || !entityProps.hasRace();
                if (!hasCharBook && !hasEmptyStats) {
                    return;
                }
                message.factionId %= CharacterCreatorEntry.FACTION.getSize() + 1;
                message.raceId %= CharacterCreatorEntry.RACE.getSize() + 1;
                message.styleId %= CharacterCreatorEntry.STYLE.getSize() + 1;
                FactionId faction = message.factionId == -1 ? (FactionId)CharacterCreatorEntry.FACTION.getInfo(rand.nextInt(CharacterCreatorEntry.FACTION.getSize())) : (FactionId)CharacterCreatorEntry.FACTION.getInfo(message.factionId);
                entityProps.setFaction(faction.getRegistryName());
                ModAdvancements.SELECT_FACTION.trigger(player, faction.getRegistryName());
                RaceId race = message.raceId == -1 || CommonConfig.INSTANCE.getRaceRandomizer() ? (RaceId)CharacterCreatorEntry.RACE.getInfo(rand.nextInt(CharacterCreatorEntry.RACE.getSize())) : (RaceId)CharacterCreatorEntry.RACE.getInfo(message.raceId);
                entityProps.setRace(race.getRegistryName());
                if (!race.getSubRaces().isEmpty()) {
                    message.minkRaceId %= race.getSubRaces().size();
                    String subRace = CommonConfig.INSTANCE.getAllowMinkRaceSelect() ? race.getSubRaces().get(message.minkRaceId) : race.getSubRaces().get(rand.nextInt(race.getSubRaces().size()));
                    entityProps.setSubRace(subRace);
                }
                ModAdvancements.SELECT_RACE.trigger(player, race.getRegistryName());
                StyleId style = message.styleId == -1 ? (StyleId)CharacterCreatorEntry.STYLE.getInfo(rand.nextInt(CharacterCreatorEntry.STYLE.getSize())) : (StyleId)CharacterCreatorEntry.STYLE.getInfo(message.styleId);
                entityProps.setFightingStyle(style.getRegistryName());
                ModAdvancements.SELECT_STYLE.trigger(player, style.getRegistryName());
                if (entityProps.isCyborg()) {
                    entityProps.setCola(entityProps.getMaxCola());
                }
                for (ItemStack is : player.field_71071_by.field_70462_a) {
                    if (is == null || !(is.func_77973_b() instanceof CharacterCreatorItem)) continue;
                    player.field_71071_by.func_184437_d(is);
                }
                SetPlayerDetailsEvent event = new SetPlayerDetailsEvent((PlayerEntity)player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(player.func_145782_y(), entityProps), (Entity)player);
                WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

