/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket2;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CRemoveAbilityPacket {
    private int slot;

    public CRemoveAbilityPacket() {
    }

    public CRemoveAbilityPacket(int id) {
        this.slot = id;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
    }

    public static CRemoveAbilityPacket decode(PacketBuffer buffer) {
        CRemoveAbilityPacket msg = new CRemoveAbilityPacket();
        msg.slot = buffer.readInt();
        return msg;
    }

    public static void handle(CRemoveAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
                Ability ability = (Ability)abilityDataProps.getEquippedAbility(message.slot);
                if (ability == null) {
                    return;
                }
                if (ability.hasComponent(ModAbilityKeys.COOLDOWN) && ability.getComponent(ModAbilityKeys.COOLDOWN).get().isOnCooldown()) {
                    return;
                }
                if (ability.hasComponent(ModAbilityKeys.DISABLE) && ability.getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
                    return;
                }
                if (ability.hasComponent(ModAbilityKeys.CONTINUOUS) && ability.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
                    return;
                }
                if (ability.hasComponent(ModAbilityKeys.CHARGE) && ability.getComponent(ModAbilityKeys.CHARGE).get().isCharging()) {
                    return;
                }
                abilityDataProps.setEquippedAbility(message.slot, null);
                if (abilityDataProps.getEquippedAbilitySlot(ability) >= 0) {
                    if (ability.isNew) {
                        WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket2((LivingEntity)player, ability), (Entity)player);
                    } else {
                        WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, ability), (Entity)player);
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

