/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class CSetCombatBarPacket {
    private int bar;

    public CSetCombatBarPacket() {
    }

    public CSetCombatBarPacket(int bar) {
        this.bar = bar;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.bar);
    }

    public static CSetCombatBarPacket decode(PacketBuffer buffer) {
        CSetCombatBarPacket msg = new CSetCombatBarPacket();
        msg.bar = buffer.readInt();
        return msg;
    }

    public static void handle(CSetCombatBarPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                int maxBars = CommonConfig.INSTANCE.getAbilityBars();
                if (maxBars < message.bar + 1) {
                    return;
                }
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityProps = (IAbilityData)AbilityDataCapability.getLazy((LivingEntity)player).orElse(null);
                if (abilityProps == null) {
                    return;
                }
                abilityProps.setCombatBarSet(message.bar);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

