/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.challenge;

import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;

public class CStartChallengePacket {
    private ResourceLocation id;
    private boolean isFree;

    public CStartChallengePacket() {
    }

    public CStartChallengePacket(ResourceLocation resourceLocation, boolean isFree) {
        this.id = resourceLocation;
        this.isFree = isFree;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.id);
        buffer.writeBoolean(this.isFree);
    }

    public static CStartChallengePacket decode(PacketBuffer buffer) {
        CStartChallengePacket msg = new CStartChallengePacket();
        msg.id = buffer.func_192575_l();
        msg.isFree = buffer.readBoolean();
        return msg;
    }

    public static void handle(CStartChallengePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                if (!CommonConfig.INSTANCE.isChallengesEnabled()) {
                    return;
                }
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ServerWorld world = (ServerWorld)player.field_70170_p;
                IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
                ChallengeCore core = (ChallengeCore)ModRegistries.CHALLENGES.getValue(message.id);
                if (core == null) {
                    return;
                }
                ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
                for (UUID id : props.getGroupMembersIds()) {
                    PlayerEntity groupMember = world.func_217371_b(id);
                    if (groupMember == null) continue;
                    list.add((LivingEntity)groupMember);
                }
                ChallengesWorldData.get().startChallenge(player, list, core, message.isFree);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

