/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.entity;

import io.netty.handler.codec.EncoderException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class CSyncPlayerInputPacket {
    private float xxa;
    private float zza;
    private boolean isJumping;

    public CSyncPlayerInputPacket() {
    }

    public CSyncPlayerInputPacket(ClientPlayerEntity player) {
        this.xxa = player.field_70702_br;
        this.zza = player.field_191988_bg;
        this.isJumping = player.field_71158_b.field_78901_c;
    }

    public void encode(PacketBuffer buffer) {
        BitSet bitSet = new BitSet(5);
        bitSet.set(0, this.xxa > 0.0f);
        bitSet.set(1, this.xxa < 0.0f);
        bitSet.set(2, this.zza > 0.0f);
        bitSet.set(3, this.zza < 0.0f);
        bitSet.set(4, this.isJumping);
        CSyncPlayerInputPacket.writeFixedBitSet(buffer, bitSet, 5);
    }

    public static CSyncPlayerInputPacket decode(PacketBuffer buffer) {
        CSyncPlayerInputPacket message = new CSyncPlayerInputPacket();
        BitSet bitSet = CSyncPlayerInputPacket.readFixedBitSet(buffer, 5);
        int xxaBits = (bitSet.get(0) ? 1 : 0) | (bitSet.get(1) ? 2 : 0);
        int zzaBits = (bitSet.get(2) ? 1 : 0) | (bitSet.get(3) ? 2 : 0);
        message.xxa = xxaBits == 2 ? -1.0f : (float)xxaBits;
        message.zza = zzaBits == 2 ? -1.0f : (float)zzaBits;
        message.isJumping = bitSet.get(4);
        return message;
    }

    public static void handle(CSyncPlayerInputPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity entity = ((NetworkEvent.Context)ctx.get()).getSender();
                entity.field_70702_br = message.xxa;
                entity.field_191988_bg = message.zza;
                entity.func_70637_d(message.isJumping);
                IEntityStats entityDataProps = EntityStatsCapability.get((LivingEntity)entity);
                entityDataProps.setLeftImpulse(message.xxa);
                entityDataProps.setForwardImpulse(message.zza);
                entityDataProps.setJumping(message.isJumping);
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static BitSet readBitSet(PacketBuffer buffer) {
        return BitSet.valueOf(buffer.func_186873_b(null));
    }

    public static void writeBitSet(PacketBuffer buffer, BitSet bits) {
        buffer.func_186865_a(bits.toLongArray());
    }

    public static BitSet readFixedBitSet(PacketBuffer buffer, int toWrite) {
        byte[] abyte = new byte[-Math.floorDiv(-toWrite, 8)];
        buffer.readBytes(abyte);
        return BitSet.valueOf(abyte);
    }

    public static void writeFixedBitSet(PacketBuffer buffer, BitSet bits, int toWrite) {
        if (bits.length() > toWrite) {
            throw new EncoderException("BitSet is larger than expected size (" + bits.length() + ">" + toWrite + ")");
        }
        byte[] abyte = bits.toByteArray();
        buffer.writeBytes(Arrays.copyOf(abyte, -Math.floorDiv(-toWrite, 8)));
    }
}

