/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ofpw;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.InventoryDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;

public class CRequestCreativeSpawnOFPWPacket {
    private ResourceLocation fruitId;

    public CRequestCreativeSpawnOFPWPacket() {
    }

    public CRequestCreativeSpawnOFPWPacket(ResourceLocation fruitId) {
        this.fruitId = fruitId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.fruitId);
    }

    public static CRequestCreativeSpawnOFPWPacket decode(PacketBuffer buffer) {
        CRequestCreativeSpawnOFPWPacket msg = new CRequestCreativeSpawnOFPWPacket();
        msg.fruitId = buffer.func_192575_l();
        return msg;
    }

    public static void handle(CRequestCreativeSpawnOFPWPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                OFPWWorldData worldProps = OFPWWorldData.get();
                if (!player.func_184812_l_() || !player.func_211513_k(2)) {
                    return;
                }
                OneFruitEntry entry = worldProps.getOneFruitEntry(message.fruitId);
                if (entry != null && entry.getStatus() != OneFruitEntry.Status.LOST) {
                    return;
                }
                worldProps.updateOneFruit(message.fruitId, player.func_110124_au(), OneFruitEntry.Status.INVENTORY, "Spawned using creative inventory");
                InventoryDevilFruitEvent event = new InventoryDevilFruitEvent((LivingEntity)player, DevilFruitHelper.getDevilFruitItem(message.fruitId), "Spawned using creative inventory");
                MinecraftForge.EVENT_BUS.post((Event)event);
            });
        }
    }
}

