/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.quest;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.entities.ITrainer;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CUpdateQuestStatePacket {
    private INBT data;
    private ResourceLocation questId;

    public CUpdateQuestStatePacket() {
    }

    public CUpdateQuestStatePacket(QuestId quest) {
        this.questId = quest.getRegistryName();
    }

    @Deprecated
    public CUpdateQuestStatePacket(IQuestData props) {
        this.data = new CompoundNBT();
        this.data = QuestDataCapability.INSTANCE.getStorage().writeNBT(QuestDataCapability.INSTANCE, (Object)props, null);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.questId);
    }

    public static CUpdateQuestStatePacket decode(PacketBuffer buffer) {
        CUpdateQuestStatePacket msg = new CUpdateQuestStatePacket();
        msg.questId = buffer.func_192575_l();
        return msg;
    }

    public static void handle(CUpdateQuestStatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                Object quest;
                if (message.questId == null) {
                    return;
                }
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Optional<ITrainer> trainer = WyHelper.getNearbyLiving(player.func_213303_ch(), (IWorld)player.field_70170_p, 10.0, null).stream().filter(ITrainer.class::isInstance).map(ITrainer.class::cast).findFirst();
                if (!trainer.isPresent()) {
                    return;
                }
                IQuestData props = QuestDataCapability.get((PlayerEntity)player);
                QuestId questId = (QuestId)GameRegistry.findRegistry(QuestId.class).getValue(message.questId);
                if (questId == null || questId.isLocked(props)) {
                    return;
                }
                if (!trainer.get().getAvailableQuests((PlayerEntity)player).stream().anyMatch(q -> ((Object)q).equals((Object)questId))) {
                    return;
                }
                boolean updateClient = false;
                if (props.hasInProgressQuest(questId) && ((Quest)((Object)props.getInProgressQuest(questId))).isComplete() && ((Quest)((Object)props.getInProgressQuest(questId))).triggerCompleteEvent((PlayerEntity)player)) {
                    props.addFinishedQuest(questId);
                    props.removeInProgressQuest(questId);
                    updateClient = true;
                } else if (!props.hasInProgressQuest(questId) && ((Quest)(quest = questId.createQuest())).triggerStartEvent((PlayerEntity)player)) {
                    props.addInProgressQuest((Quest)quest);
                    updateClient = true;
                }
                if (updateClient) {
                    WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
                    WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), (PlayerEntity)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

