/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;

public class SSetEffectDetailsPacket {
    private int entityId;
    private int effectId;
    private int duration;

    public SSetEffectDetailsPacket() {
    }

    public SSetEffectDetailsPacket(int entityId, EffectInstance instance) {
        this.entityId = entityId;
        this.effectId = (byte)(Effect.func_188409_a((Effect)instance.func_188419_a()) & 0xFF);
        this.duration = instance.func_76459_b();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.effectId);
        buffer.writeInt(this.duration);
    }

    public static SSetEffectDetailsPacket decode(PacketBuffer buffer) {
        SSetEffectDetailsPacket msg = new SSetEffectDetailsPacket();
        msg.entityId = buffer.readInt();
        msg.effectId = buffer.readInt();
        msg.duration = buffer.readInt();
        return msg;
    }

    public static void handle(SSetEffectDetailsPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetEffectDetailsPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            Effect effect = Effect.func_188412_a((int)(message.effectId & 0xFF));
            if (livingTarget.func_70644_a(effect)) {
                ((EffectInstanceMixin)livingTarget.func_70660_b(effect)).setDuration(message.duration);
            }
        }
    }
}

