/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;

public class SSetFlagOnFirePacket {
    private BlockPos pos;
    private boolean value;

    public SSetFlagOnFirePacket() {
    }

    public SSetFlagOnFirePacket(BlockPos pos, boolean value) {
        this.pos = pos;
        this.value = value;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeBoolean(this.value);
    }

    public static SSetFlagOnFirePacket decode(PacketBuffer buffer) {
        SSetFlagOnFirePacket msg = new SSetFlagOnFirePacket();
        msg.pos = buffer.func_179259_c();
        msg.value = buffer.readBoolean();
        return msg;
    }

    public static void handle(SSetFlagOnFirePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetFlagOnFirePacket message) {
            TileEntity tileEntity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            BlockState state = world.func_180495_p(message.pos);
            if (state.func_177230_c() instanceof FlagBlock && (tileEntity = world.func_175625_s(message.pos)) != null && tileEntity instanceof FlagTileEntity) {
                FlagTileEntity flagTile = (FlagTileEntity)tileEntity;
                flagTile.setOnFire(message.value);
            }
        }
    }
}

