/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SSetCombatBarPacket {
    private int bar;

    public SSetCombatBarPacket() {
    }

    public SSetCombatBarPacket(int bar) {
        this.bar = bar;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.bar);
    }

    public static SSetCombatBarPacket decode(PacketBuffer buffer) {
        SSetCombatBarPacket msg = new SSetCombatBarPacket();
        msg.bar = buffer.readInt();
        return msg;
    }

    public static void handle(SSetCombatBarPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetCombatBarPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            IAbilityData abilityProps = (IAbilityData)AbilityDataCapability.getLazy((LivingEntity)player).orElse(null);
            if (abilityProps == null) {
                return;
            }
            abilityProps.setCombatBarSet(message.bar);
        }
    }
}

