/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.awt.Color;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CSetHakiColorPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class SSetHakiColorPacket {
    private int entityId;
    private CommonConfig.HaoshokuColoringLogic coloringLogic;

    public SSetHakiColorPacket() {
    }

    public SSetHakiColorPacket(int entityId, CommonConfig.HaoshokuColoringLogic coloringLogic) {
        this.entityId = entityId;
        this.coloringLogic = coloringLogic;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.coloringLogic.ordinal());
    }

    public static SSetHakiColorPacket decode(PacketBuffer buffer) {
        SSetHakiColorPacket msg = new SSetHakiColorPacket();
        msg.entityId = buffer.readInt();
        msg.coloringLogic = CommonConfig.HaoshokuColoringLogic.values()[buffer.readInt()];
        return msg;
    }

    public static void handle(SSetHakiColorPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetHakiColorPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            IHakiData props = HakiDataCapability.get((LivingEntity)target);
            int color = 0xFF0000;
            if (message.coloringLogic == CommonConfig.HaoshokuColoringLogic.CUSTOM) {
                color = ClientConfig.INSTANCE.getHakiColor().getRGB();
            } else if (message.coloringLogic == CommonConfig.HaoshokuColoringLogic.RANDOM) {
                Random rand = new Random(target.func_110124_au().getMostSignificantBits());
                int r = (int)WyHelper.randomWithRange(rand, 0, 255);
                int g = (int)WyHelper.randomWithRange(rand, 0, 255);
                int b = (int)WyHelper.randomWithRange(rand, 0, 255);
                Color c = new Color(r, g, b);
                color = c.getRGB();
            }
            int colorRGB = WyHelper.intToRGB(color, 50).getRGB();
            props.setHaoshokuHakiColour(colorRGB);
            WyNetwork.sendToServer(new CSetHakiColorPacket(colorRGB));
        }
    }
}

