/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.audio.DrumsOfLiberationTickableSound;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class SToggleDrumsOfLiberationSoundPacket {
    private int entityId;
    private boolean shouldPlay;

    public SToggleDrumsOfLiberationSoundPacket() {
    }

    public SToggleDrumsOfLiberationSoundPacket(LivingEntity entity, boolean shouldPlay) {
        this.entityId = entity.func_145782_y();
        this.shouldPlay = shouldPlay;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.shouldPlay);
    }

    public static SToggleDrumsOfLiberationSoundPacket decode(PacketBuffer buffer) {
        SToggleDrumsOfLiberationSoundPacket msg = new SToggleDrumsOfLiberationSoundPacket();
        msg.entityId = buffer.readInt();
        msg.shouldPlay = buffer.readBoolean();
        return msg;
    }

    public static void handle(SToggleDrumsOfLiberationSoundPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SToggleDrumsOfLiberationSoundPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            Entity soundSource = mc.field_71441_e.func_73045_a(message.entityId);
            if (soundSource == null) {
                return;
            }
            if (message.shouldPlay) {
                mc.func_147118_V().func_147682_a((ISound)new DrumsOfLiberationTickableSound((SoundEvent)ModSounds.DRUMS_OF_LIBERATION_1.get(), 0, soundSource));
                mc.func_147118_V().func_147682_a((ISound)new DrumsOfLiberationTickableSound((SoundEvent)ModSounds.DRUMS_OF_LIBERATION_2.get(), 1, soundSource));
            } else {
                mc.func_147118_V().func_195478_a(((SoundEvent)ModSounds.DRUMS_OF_LIBERATION_1.get()).func_187503_a(), SoundCategory.PLAYERS);
                mc.func_147118_V().func_195478_a(((SoundEvent)ModSounds.DRUMS_OF_LIBERATION_2.get()).func_187503_a(), SoundCategory.PLAYERS);
            }
        }
    }
}

