/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SUpdatePassiveAbilityDataPacket {
    private int entityId;
    private ResourceLocation abilityId;
    private CompoundNBT nbtData;

    public SUpdatePassiveAbilityDataPacket() {
    }

    public SUpdatePassiveAbilityDataPacket(LivingEntity entity, IAbility ability) {
        this.entityId = entity.func_145782_y();
        this.abilityId = ability.getCore().getRegistryName();
        this.nbtData = ability.save(new CompoundNBT());
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_192572_a(this.abilityId);
        buffer.func_150786_a(this.nbtData);
    }

    public static SUpdatePassiveAbilityDataPacket decode(PacketBuffer buffer) {
        SUpdatePassiveAbilityDataPacket msg = new SUpdatePassiveAbilityDataPacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.func_192575_l();
        msg.nbtData = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SUpdatePassiveAbilityDataPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientHandler {
        public static void handle(SUpdatePassiveAbilityDataPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            Entity entity = mc.field_71441_e.func_73045_a(message.entityId);
            if (entity == null || !(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)entity;
            IAbilityData abilityProps = AbilityDataCapability.get(target);
            AbilityCore<?> core = AbilityCore.get(message.abilityId);
            if (core == null) {
                return;
            }
            Object ability = abilityProps.getPassiveAbility(core);
            if (ability == null) {
                return;
            }
            ability.load(message.nbtData);
        }
    }
}

